/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.ValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PathValidationService
extends ValidationService {
    protected boolean resourceMustExist;
    protected FileSystemResourceType validResourceType;
    private FileExtensionsService fileExtensionsService;

    @Override
    protected void init() {
        super.init();
        final IModelElement element = this.context(IModelElement.class);
        final ModelProperty property = this.context(ModelProperty.class);
        this.resourceMustExist = property.hasAnnotation(MustExist.class);
        ValidFileSystemResourceType validResourceTypeAnnotation = property.getAnnotation(ValidFileSystemResourceType.class);
        this.validResourceType = validResourceTypeAnnotation != null ? validResourceTypeAnnotation.value() : null;
        this.fileExtensionsService = element.service(property, FileExtensionsService.class);
        if (this.fileExtensionsService != null) {
            this.fileExtensionsService.attach(new Listener(){

                public void handle(Event event) {
                    element.refresh(property);
                }
            });
        }
    }

    protected final Status validateExtensions(Path path) {
        String fileName;
        if (this.fileExtensionsService != null && (fileName = path.lastSegment()) != null) {
            return PathValidationService.validateExtensions(fileName, this.fileExtensionsService.extensions());
        }
        return Status.createOkStatus();
    }

    public static final Status validateExtensions(String fileName, List<String> validFileExtensions) {
        int count;
        int n = count = validFileExtensions == null ? 0 : validFileExtensions.size();
        if (count > 0) {
            String trimmedFileName = fileName.trim();
            int lastdot = trimmedFileName.lastIndexOf(46);
            String extension = lastdot == -1 ? "" : trimmedFileName.substring(lastdot + 1);
            boolean match = false;
            if (extension != null && extension.length() != 0) {
                for (String ext : validFileExtensions) {
                    if (!extension.equalsIgnoreCase(ext)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                String message;
                if (count == 1) {
                    message = NLS.bind(Resources.invalidFileExtensionOne, trimmedFileName, validFileExtensions.get(0));
                } else if (count == 2) {
                    message = NLS.bind(Resources.invalidFileExtensionTwo, trimmedFileName, validFileExtensions.get(0), validFileExtensions.get(1));
                } else {
                    StringBuilder buf = new StringBuilder();
                    for (String ext : validFileExtensions) {
                        if (buf.length() != 0) {
                            buf.append(", ");
                        }
                        buf.append(ext);
                    }
                    message = NLS.bind(Resources.invalidFileExtensionMultiple, trimmedFileName, buf.toString());
                }
                return Status.createErrorStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    protected static final class Resources
    extends NLS {
        public static String folderMustExist;
        public static String fileMustExist;
        public static String resourceMustExist;
        public static String pathIsNotFile;
        public static String pathIsNotFolder;
        public static String invalidFileExtensionOne;
        public static String invalidFileExtensionTwo;
        public static String invalidFileExtensionMultiple;

        static {
            Resources.initializeMessages(PathValidationService.class.getName(), Resources.class);
        }

        protected Resources() {
        }
    }
}

