/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceFactoryProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContext {
    public static final String ID_ELEMENT_INSTANCE = "Sapphire.Element.Instance";
    public static final String ID_ELEMENT_METAMODEL = "Sapphire.Element.MetaModel";
    public static final String ID_PROPERTY_INSTANCE = "Sapphire.Property.Instance";
    public static final String ID_PROPERTY_METAMODEL = "Sapphire.Property.MetaModel";
    private final String type;
    private final ServiceContext parent;
    private final List<Service> services = new ArrayList<Service>();
    private final Set<Class<?>> initializedServiceTypes = new HashSet();
    private final Set<String> exhaustedServiceFactories = new HashSet<String>();
    private boolean disposed = false;

    public ServiceContext(String type, ServiceContext parent) {
        this.type = type;
        this.parent = parent;
    }

    public final String type() {
        return this.type;
    }

    public final ServiceContext parent() {
        return this.parent;
    }

    public <T> T find(Class<T> type) {
        return null;
    }

    public final <S extends Service> S service(Class<S> serviceType) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    public final synchronized <S extends Service> List<S> services(Class<S> serviceType) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        if (!this.initializedServiceTypes.contains(serviceType)) {
            Service service;
            String id;
            this.initializedServiceTypes.add(serviceType);
            HashMap<String, ServiceFactoryProxy> applicable = new HashMap<String, ServiceFactoryProxy>();
            for (ServiceFactoryProxy factory : SapphireModelingExtensionSystem.getServiceFactories()) {
                if (!factory.applicable(this, serviceType)) continue;
                applicable.put(factory.id(), factory);
            }
            for (ServiceFactoryProxy factory : new ArrayList(applicable.values())) {
                for (String overriddenServiceId : factory.overrides()) {
                    applicable.remove(overriddenServiceId);
                }
            }
            for (ServiceFactoryProxy factory : this.local()) {
                id = factory.id();
                if (this.exhaustedServiceFactories.contains(id) || !factory.applicable(this, serviceType)) continue;
                this.exhaustedServiceFactories.add(id);
                service = null;
                try {
                    service = factory.create(this, serviceType);
                    service.init(this, factory.parameters());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
                if (service == null) continue;
                for (String overriddenServiceId : factory.overrides()) {
                    applicable.remove(overriddenServiceId);
                }
                this.services.add(service);
                try {
                    service.init();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            for (ServiceFactoryProxy factory : applicable.values()) {
                id = factory.id();
                if (this.exhaustedServiceFactories.contains(id)) continue;
                this.exhaustedServiceFactories.add(id);
                service = null;
                try {
                    service = factory.create(this, serviceType);
                    service.init(this, factory.parameters());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
                if (service == null) continue;
                this.services.add(service);
                try {
                    service.init();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
        }
        ArrayList<Service> result = new ArrayList<Service>(1);
        for (Service service : this.services) {
            if (!serviceType.isInstance(service)) continue;
            result.add((Service)serviceType.cast(service));
        }
        if (this.parent != null && result.isEmpty()) {
            result.addAll(this.parent.services(serviceType));
        }
        return Collections.unmodifiableList(result);
    }

    protected List<ServiceFactoryProxy> local() {
        return Collections.emptyList();
    }

    public final void dispose() {
        this.disposed = true;
        for (Service service : this.services) {
            try {
                service.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
        this.services.clear();
    }
}

