/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.HashSet;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.services.DependenciesService;
import org.eclipse.sapphire.services.DependenciesServiceData;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class DeclarativeDependenciesService
extends DependenciesService {
    protected DependenciesServiceData compute() {
        HashSet<String> dependenciesAsStrings = new HashSet<String>();
        DependsOn dependsOnAnnotation = this.context(ModelProperty.class).getAnnotation(DependsOn.class);
        if (dependsOnAnnotation != null) {
            String[] stringArray = dependsOnAnnotation.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dependsOnPropertyRef = stringArray[n2];
                dependenciesAsStrings.add(dependsOnPropertyRef);
                ++n2;
            }
        }
        HashSet<ModelPath> dependencies = new HashSet<ModelPath>();
        for (String str : dependenciesAsStrings) {
            ModelPath path = null;
            try {
                path = new ModelPath(str);
            }
            catch (ModelPath.MalformedPathException e) {
                LoggingService.log(e);
            }
            dependencies.add(path);
        }
        return new DependenciesServiceData(dependencies);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return context.find(ModelProperty.class).hasAnnotation(DependsOn.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new DeclarativeDependenciesService();
        }
    }
}

