/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class FunctionBasedEnablementService
extends EnablementService {
    private final List<FunctionResult> functionResults = new ArrayList<FunctionResult>();

    protected void initEnablementService() {
        ModelElementFunctionContext fnContext = new ModelElementFunctionContext(this.context(IModelElement.class));
        Listener functionResultListener = new Listener(){

            public void handle(Event event) {
                FunctionBasedEnablementService.this.refresh();
            }
        };
        for (Enablement annotation : this.context(ModelProperty.class).getAnnotations(Enablement.class)) {
            Function function = null;
            try {
                function = ExpressionLanguageParser.parse(annotation.expr());
            }
            catch (Exception e) {
                LoggingService.log(e);
                function = null;
            }
            if (function == null) continue;
            function = FailSafeFunction.create(function, Literal.create(Boolean.class), Literal.create(Boolean.FALSE));
            FunctionResult functionResult = function.evaluate(fnContext);
            functionResult.attach(functionResultListener);
            this.functionResults.add(functionResult);
        }
    }

    protected EnablementServiceData compute() {
        boolean state = true;
        for (FunctionResult result : this.functionResults) {
            boolean bl = state = state && (Boolean)result.value() != false;
        }
        return new EnablementServiceData(state);
    }

    public void dispose() {
        super.dispose();
        for (FunctionResult result : this.functionResults) {
            try {
                result.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return context.find(ModelProperty.class).hasAnnotation(Enablement.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new FunctionBasedEnablementService();
        }
    }
}

