/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.util.internal.SapphireCommonUtil;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericRangeFactsService
extends FactsService {
    @Override
    protected void facts(List<String> facts) {
        ValueProperty property = this.context(ValueProperty.class);
        NumericRange range = property.getAnnotation(NumericRange.class);
        String min = range.min();
        String max = range.max();
        if (min.length() > 0) {
            facts.add(NLS.bind(Resources.minValueStatement, SapphireCommonUtil.normalizeForDisplay(property, min)));
        }
        if (max.length() > 0) {
            facts.add(NLS.bind(Resources.maxValueStatement, SapphireCommonUtil.normalizeForDisplay(property, max)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                NumericRange range = property.getAnnotation(NumericRange.class);
                return range != null && (range.min().length() > 0 || range.max().length() > 0);
            }
            return false;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new NumericRangeFactsService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String minValueStatement;
        public static String maxValueStatement;

        static {
            Resources.initializeMessages(NumericRangeFactsService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

