/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.AnnotationsAwareServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyServiceContext
extends AnnotationsAwareServiceContext {
    private final ModelProperty property;

    public PropertyServiceContext(String type, ServiceContext parent, ModelProperty property) {
        super(type, parent);
        this.property = property;
    }

    @Override
    public <T> T find(Class<T> type) {
        Object obj = super.find(type);
        if (obj == null) {
            if (type == ModelProperty.class) {
                obj = this.property;
            } else if (type == ValueProperty.class) {
                if (this.property instanceof ValueProperty) {
                    obj = this.property;
                }
            } else if (type == ListProperty.class) {
                if (this.property instanceof ListProperty) {
                    obj = this.property;
                }
            } else if (type == ElementProperty.class) {
                if (this.property instanceof ElementProperty) {
                    obj = this.property;
                }
            } else if (type == ImpliedElementProperty.class) {
                if (this.property instanceof ImpliedElementProperty) {
                    obj = this.property;
                }
            } else if (type == TransientProperty.class && this.property instanceof TransientProperty) {
                obj = this.property;
            }
        }
        return obj;
    }

    @Override
    protected <A extends Annotation> List<A> annotations(Class<A> type) {
        return this.property.getAnnotations(type);
    }
}

