/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public final class ReferenceValidationService
extends ValidationService {
    private ReferenceService referenceService;
    private Listener referenceServiceListener;

    protected void init() {
        super.init();
        IModelElement element = this.context(IModelElement.class);
        ValueProperty property = this.context(ValueProperty.class);
        this.referenceService = element.service(property, ReferenceService.class);
        if (this.referenceService != null) {
            this.referenceServiceListener = new Listener(){

                public void handle(Event event) {
                    ReferenceValidationService.this.broadcast();
                }
            };
            this.referenceService.attach(this.referenceServiceListener);
        }
    }

    public Status validate() {
        ReferenceValue value = (ReferenceValue)this.context(IModelElement.class).read(this.context(ValueProperty.class));
        if (value.resolve() == null && value.getText() != null) {
            ValueProperty property = value.getProperty();
            String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
            String str = value.getText();
            String msg = NLS.bind(Resources.message, label, str);
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        super.dispose();
        if (this.referenceServiceListener != null) {
            this.referenceService.detach(this.referenceServiceListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(Reference.class) && property.hasAnnotation(MustExist.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new ReferenceValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages(ReferenceValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

