/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.io.File;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.PathValidationService;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class RelativePathValidationService
extends PathValidationService {
    public Status validate() {
        Value value = this.context(IModelElement.class).read(this.context(ValueProperty.class));
        Path path = (Path)value.getContent();
        if (path != null) {
            Path absolutePath = this.context(IModelElement.class).service(this.context(ModelProperty.class), RelativePathService.class).convertToAbsolute(path);
            if (absolutePath == null) {
                String message = PathValidationService.Resources.bind(LocalResources.couldNotResolveRelative, path.toString());
                return Status.createErrorStatus(message);
            }
            File absolutePathFile = absolutePath.toFile();
            if (absolutePathFile.exists()) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    if (absolutePathFile.isFile()) {
                        return this.validateExtensions(path);
                    }
                    String message = NLS.bind(PathValidationService.Resources.pathIsNotFile, absolutePath.toPortableString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER && !absolutePathFile.isDirectory()) {
                    String message = NLS.bind(PathValidationService.Resources.pathIsNotFolder, absolutePath.toPortableString());
                    return Status.createErrorStatus(message);
                }
                return Status.createOkStatus();
            }
            if (this.resourceMustExist) {
                String message;
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    message = PathValidationService.Resources.bind(PathValidationService.Resources.fileMustExist, path.toString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER) {
                    message = PathValidationService.Resources.bind(PathValidationService.Resources.folderMustExist, path.toString());
                    return Status.createErrorStatus(message);
                }
                message = PathValidationService.Resources.bind(PathValidationService.Resources.resourceMustExist, path.toString());
                return Status.createErrorStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            IModelElement element = context.find(IModelElement.class);
            return property != null && Path.class.isAssignableFrom(property.getTypeClass()) && element.service(property, RelativePathService.class) != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new RelativePathValidationService();
        }
    }

    private static final class LocalResources
    extends NLS {
        public static String couldNotResolveRelative;

        static {
            LocalResources.initializeMessages(RelativePathValidationService.class.getName(), LocalResources.class);
        }

        private LocalResources() {
        }
    }
}

