/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphirePropertyEditorActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;

public final class PrefixActionHandlerForList
extends SapphirePropertyEditorActionHandler {
    private String prefix;

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.prefix = String.valueOf(def.getParam("prefix")) + " ";
        final IModelElement element = this.getModelElement();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PrefixActionHandlerForList.this.refreshEnabledState();
                PrefixActionHandlerForList.this.refreshCheckedState();
            }
        };
        String path = String.valueOf(this.getProperty().getName()) + "/*";
        element.attach((Listener)listener, path);
        this.refreshEnabledState();
        this.refreshCheckedState();
        this.attach((Listener)new FilteredListener<DisposeEvent>((Listener)listener, path){
            private final /* synthetic */ Listener val$listener;
            private final /* synthetic */ String val$path;
            {
                this.val$listener = listener;
                this.val$path = string;
            }

            protected void handleTypedEvent(DisposeEvent event) {
                element.detach(this.val$listener, this.val$path);
            }
        });
    }

    public ListProperty getProperty() {
        return (ListProperty)super.getProperty();
    }

    protected Object run(SapphireRenderingContext context) {
        ModelElementList list = this.getModelElement().read(this.getProperty());
        if (!list.isEmpty()) {
            IModelElement element = list.get(0);
            ValueProperty property = (ValueProperty)element.properties().get(0);
            String oldValue = element.read(property).getText();
            Object newValue = this.isChecked() ? String.valueOf(this.prefix) + oldValue : (oldValue.startsWith(this.prefix) ? (oldValue.length() == this.prefix.length() ? null : oldValue.substring(this.prefix.length())) : oldValue);
            element.write(property, newValue);
        }
        return null;
    }

    private void refreshEnabledState() {
        this.setEnabled(!this.getModelElement().read(this.getProperty()).isEmpty());
    }

    private void refreshCheckedState() {
        boolean checked = false;
        ModelElementList list = this.getModelElement().read(this.getProperty());
        if (!list.isEmpty()) {
            ValueProperty property;
            IModelElement element = list.get(0);
            String value = element.read(property = (ValueProperty)element.properties().get(0)).getText();
            checked = value != null && value.startsWith(this.prefix);
        }
        this.setChecked(checked);
    }
}

