/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.po;

import java.math.BigDecimal;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenerateImpl
public interface PurchaseOrderEntry
extends IModelElement {
    public static final ModelElementType TYPE = new ModelElementType(PurchaseOrderEntry.class);
    @Label(standard="item")
    @Required
    public static final ValueProperty PROP_ITEM = new ValueProperty(TYPE, "Item");
    @Label(standard="description")
    @LongString
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, "Description");
    @Type(base=Integer.class)
    @Label(standard="quantity")
    @Required
    @DefaultValue(text="1")
    public static final ValueProperty PROP_QUANTITY = new ValueProperty(TYPE, "Quantity");
    @Type(base=BigDecimal.class)
    @Label(standard="unit price")
    @NumericRange(min="0")
    @Required
    public static final ValueProperty PROP_UNIT_PRICE = new ValueProperty(TYPE, "UnitPrice");
    @Type(base=BigDecimal.class)
    @Label(standard="total")
    @Derived(text="${ Scale( UnitPrice * Scale( Quantity, 2 ), 2 ) }")
    public static final ValueProperty PROP_TOTAL = new ValueProperty(TYPE, "Total");

    public Value<String> getItem();

    public void setItem(String var1);

    public Value<String> getDescription();

    public void setDescription(String var1);

    public Value<Integer> getQuantity();

    public void setQuantity(String var1);

    public void setQuantity(Integer var1);

    public Value<BigDecimal> getUnitPrice();

    public void setUnitPrice(String var1);

    public void setUnitPrice(BigDecimal var1);

    public Value<BigDecimal> getTotal();
}

