/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.sdk.build.processor.internal.util.AccessModifier;
import org.eclipse.sapphire.sdk.build.processor.internal.util.BaseModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.Body;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ClassModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.IndentingPrintWriter;
import org.eclipse.sapphire.sdk.build.processor.internal.util.MethodParameterModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodModel
extends BaseModel {
    private String name;
    private TypeReference returnType = TypeReference.VOID_TYPE;
    private final List<MethodParameterModel> parameters = new ArrayList<MethodParameterModel>();
    private boolean isAbstract = false;
    private boolean isConstructor = false;
    private boolean isStatic = false;
    private boolean isFinal = false;
    private AccessModifier accessModifier = AccessModifier.PUBLIC;
    private Body body = new Body();

    @Override
    public ClassModel getParent() {
        return (ClassModel)super.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeReference getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TypeReference returnType) {
        this.returnType = returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.setReturnType(new TypeReference(returnType));
    }

    public List<MethodParameterModel> getParameters() {
        return this.parameters;
    }

    public void addParameter(MethodParameterModel parameter) {
        this.parameters.add(parameter);
        parameter.setParent(this);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void isFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public void setAccessModifier(AccessModifier accessModifier) {
        this.accessModifier = accessModifier;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public void write(IndentingPrintWriter pw) {
        this.accessModifier.write(pw);
        if (!this.isConstructor) {
            if (this.isAbstract) {
                pw.print("abstract ");
            } else {
                if (this.isStatic) {
                    pw.print("static ");
                }
                if (this.isFinal) {
                    pw.print("final ");
                }
            }
            pw.print(this.returnType.getSimpleName());
            pw.print(' ');
            pw.print(this.name);
        } else {
            pw.print(this.getParent().getName().getSimpleName());
        }
        if (this.parameters.isEmpty()) {
            pw.print("()");
        } else {
            pw.print('(');
            boolean isFirst = true;
            for (MethodParameterModel param : this.parameters) {
                if (this.isAbstract()) {
                    param.setFinal(false);
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    pw.print(',');
                }
                pw.print(' ');
                param.write(pw);
            }
            pw.print(" )");
        }
        if (this.isAbstract) {
            pw.print(';');
        } else {
            pw.println();
            pw.print('{');
            pw.println();
            pw.increaseIndent();
            this.body.write(pw);
            pw.decreaseIndent();
            pw.print('}');
        }
        pw.println();
        pw.println();
    }
}

