/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ArrayTypeReference;
import org.eclipse.sapphire.sdk.build.processor.internal.util.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterizedTypeReference
extends TypeReference {
    private static final String ARRAY_NOTATION = "[]";
    private static final String[] COMMON_ARRAY_DIMENSIONS = new String[5];
    private final TypeReference base;
    private final List<TypeReference> parameters;

    static {
        int i = 1;
        while (i < COMMON_ARRAY_DIMENSIONS.length) {
            ParameterizedTypeReference.COMMON_ARRAY_DIMENSIONS[i] = String.valueOf(COMMON_ARRAY_DIMENSIONS[i - 1]) + ARRAY_NOTATION;
            ++i;
        }
    }

    public ParameterizedTypeReference(TypeReference base, TypeReference ... parameters) {
        super(String.valueOf(base.getQualifiedName()) + ParameterizedTypeReference.generateParametersNotation(parameters));
        if (base instanceof ArrayTypeReference) {
            throw new IllegalArgumentException();
        }
        this.base = base;
        ArrayList<TypeReference> params = new ArrayList<TypeReference>();
        TypeReference[] typeReferenceArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference param = typeReferenceArray[n2];
            params.add(param);
            ++n2;
        }
        this.parameters = Collections.unmodifiableList(params);
    }

    @Override
    public TypeReference getBase() {
        return this.base;
    }

    public List<TypeReference> getParameters() {
        return this.parameters;
    }

    @Override
    public void contributeNecessaryImports(Set<TypeReference> imports) {
        this.base.contributeNecessaryImports(imports);
        for (TypeReference param : this.parameters) {
            param.contributeNecessaryImports(imports);
        }
    }

    private static String generateParametersNotation(TypeReference ... parameters) {
        StringBuilder buf = new StringBuilder();
        buf.append('<');
        boolean first = true;
        TypeReference[] typeReferenceArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference param = typeReferenceArray[n2];
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(param.getSimpleName());
            ++n2;
        }
        buf.append('>');
        return buf.toString();
    }
}

