/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.extensibility.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.sdk.extensibility.ServiceContextRef;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceContextRefImpl
extends ModelElement
implements ServiceContextRef {
    private Value<String> pContext;

    public ServiceContextRefImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ServiceContextRefImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getContext() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pContext == null) {
                this.refresh((ModelProperty)PROP_CONTEXT, true);
            }
            return this.pContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContext(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CONTEXT.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_CONTEXT, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_CONTEXT, true);
            if (!ServiceContextRefImpl.equal((String)this.pContext.getText(false), (String)value)) {
                this.resource().binding(PROP_CONTEXT).write(value);
                this.refresh((ModelProperty)PROP_CONTEXT, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CONTEXT && (this.pContext != null || force)) {
                Value<String> oldValue = this.pContext;
                String val = this.resource().binding(PROP_CONTEXT).read();
                this.pContext = new Value((IModelElement)this, PROP_CONTEXT, ((ValueNormalizationService)this.service((ModelProperty)PROP_CONTEXT, ValueNormalizationService.class)).normalize(PROP_CONTEXT.encodeKeywords(val)));
                this.pContext.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CONTEXT);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CONTEXT));
                } else {
                    if (this.pContext.equals(oldValue)) {
                        this.pContext = oldValue;
                    } else {
                        if (!ServiceContextRefImpl.equal((String)this.pContext.getText(false), (String)oldValue.getText(false)) || !ServiceContextRefImpl.equal((String)this.pContext.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_CONTEXT));
                        }
                        if (!this.pContext.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_CONTEXT, oldValue.validation(), this.pContext.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CONTEXT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CONTEXT) {
            return this.getContext();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_CONTEXT) {
            this.setContext((String)value);
            return;
        }
        super.write(property, value);
    }
}

