/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.sdk.CreateExtensionManifestOp;
import org.eclipse.sapphire.sdk.extensibility.SapphireExtensionDef;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class CreateExtensionManifestOpMethods {
    public static Status execute(CreateExtensionManifestOp operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Resources.executeTaskName, 3);
        try {
            IFile newFileHandle = operation.getFileHandle();
            try {
                newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                if (newFileHandle.exists()) {
                    newFileHandle.setContents((InputStream)new ByteArrayInputStream(new byte[0]), 1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                monitor.done();
                return status;
            }
            monitor.worked(1);
            try {
                RootXmlResource resource = new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(newFileHandle)));
                SapphireExtensionDef model = (SapphireExtensionDef)SapphireExtensionDef.TYPE.instantiate((Resource)resource);
                ((XmlResource)model.adapt(XmlResource.class)).getXmlElement(true);
                model.resource().save();
            }
            catch (ResourceStoreException e) {
                Status status = Status.createErrorStatus((Throwable)e);
                monitor.done();
                return status;
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;

        static {
            Resources.initializeMessages((String)CreateExtensionManifestOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

