/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0003.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;
import org.eclipse.sapphire.tests.modeling.events.t0003.ChildElement;
import org.eclipse.sapphire.tests.modeling.events.t0003.RootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RootElementImpl
extends ModelElement
implements RootElement {
    private ModelElementHandle<ChildElement> pChild;
    private Value<Boolean> pEnablement;

    public RootElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public RootElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<ChildElement> getChild() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pChild == null) {
                this.refresh((ModelProperty)PROP_CHILD, true);
            }
            return this.pChild;
        }
    }

    protected void disposeProperties() {
        IModelElement element;
        if (this.pChild != null && (element = this.pChild.element(false)) != null) {
            element.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Boolean> getEnablement() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pEnablement == null) {
                this.refresh((ModelProperty)PROP_ENABLEMENT, true);
            }
            return this.pEnablement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnablement(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ENABLEMENT.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ENABLEMENT, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ENABLEMENT, true);
            if (!RootElementImpl.equal((String)this.pEnablement.getText(false), (String)value)) {
                this.resource().binding(PROP_ENABLEMENT).write(value);
                this.refresh((ModelProperty)PROP_ENABLEMENT, false);
            }
        }
    }

    @Override
    public void setEnablement(Boolean value) {
        this.setEnablement(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_ENABLEMENT, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CHILD) {
                if (this.pChild == null) {
                    if (force) {
                        this.pChild = new ModelElementHandle((IModelElement)this, PROP_CHILD);
                        this.pChild.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_CHILD);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CHILD));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CHILD);
                    boolean notified = this.pChild.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CHILD, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_ENABLEMENT && (this.pEnablement != null || force)) {
                Value<Boolean> oldValue = this.pEnablement;
                String val = this.resource().binding(PROP_ENABLEMENT).read();
                this.pEnablement = new Value((IModelElement)this, PROP_ENABLEMENT, ((ValueNormalizationService)this.service((ModelProperty)PROP_ENABLEMENT, ValueNormalizationService.class)).normalize(PROP_ENABLEMENT.encodeKeywords(val)));
                this.pEnablement.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ENABLEMENT);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT));
                } else {
                    if (this.pEnablement.equals(oldValue)) {
                        this.pEnablement = oldValue;
                    } else {
                        if (!RootElementImpl.equal((String)this.pEnablement.getText(false), (String)oldValue.getText(false)) || !RootElementImpl.equal((String)this.pEnablement.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT));
                        }
                        if (!this.pEnablement.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT, oldValue.validation(), this.pEnablement.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ENABLEMENT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CHILD) {
            return this.getChild();
        }
        if (property == PROP_ENABLEMENT) {
            return this.getEnablement();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_ENABLEMENT) {
            if (!(value instanceof String)) {
                this.setEnablement((Boolean)value);
            } else {
                this.setEnablement((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

