/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.def.ImagePlacement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramNodeModel
extends DiagramModelBase {
    public static final int DEFAULT_NODE_WIDTH = 100;
    public static final int DEFAULT_NODE_HEIGHT = 30;
    private static final int DEFAULT_TEXT_HEIGHT = 16;
    public static final String SOURCE_CONNECTIONS = "SOURCE_CONNECTIONS";
    public static final String TARGET_CONNECTIONS = "TARGET_CONNECTIONS";
    public static final String NODE_BOUNDS = "NODE_BOUNDS";
    public static final String NODE_UPDATES = "NODE_UPDATES";
    public static final String NODE_START_EDITING = "NODE_START_EDITING";
    private DiagramModel parent;
    private DiagramNodePart part;
    private List<DiagramConnectionModel> sourceConnections = new ArrayList<DiagramConnectionModel>();
    private List<DiagramConnectionModel> targetConnections = new ArrayList<DiagramConnectionModel>();

    public DiagramNodeModel(DiagramModel parent, DiagramNodePart part) {
        this.parent = parent;
        this.part = part;
    }

    public DiagramModel getDiagramModel() {
        return this.parent;
    }

    @Override
    public SapphirePart getSapphirePart() {
        return this.getModelPart();
    }

    public DiagramNodePart getModelPart() {
        return this.part;
    }

    public String getLabel() {
        return this.getModelPart().getLabel();
    }

    public Image getImage() {
        ImageData imageData = this.getModelPart().getImage();
        if (imageData != null) {
            return this.getModelPart().getImageCache().getImage(imageData);
        }
        return null;
    }

    public Bounds getNodeBounds() {
        DiagramNodeBounds bounds = this.getModelPart().getNodeBounds();
        if (bounds.getWidth() < 0 || bounds.getHeight() < 0) {
            Image image;
            DiagramNodePart nodePart = this.getModelPart();
            int labelWidth = nodePart.getLabelWidth();
            if (labelWidth <= 0) {
                labelWidth = 100;
            }
            if ((image = this.getImage()) != null) {
                ImagePlacement imagePlacement;
                int imageWidth = nodePart.getImageWidth();
                if (imageWidth == 0) {
                    imageWidth = image.getImageData().width;
                }
                if ((imagePlacement = nodePart.getImagePlacement()) == ImagePlacement.TOP || imagePlacement == ImagePlacement.BOTTOM) {
                    labelWidth = Math.max(labelWidth, imageWidth);
                } else if (imagePlacement == ImagePlacement.LEFT || imagePlacement == ImagePlacement.RIGHT) {
                    int horizaontalSpacing = nodePart.getHorizontalSpacing();
                    labelWidth = labelWidth + imageWidth + horizaontalSpacing;
                }
            }
            bounds.setWidth(labelWidth);
            int labelHeight = nodePart.getLabelHeight();
            labelHeight = Math.max(labelHeight, 16);
            if (image != null) {
                ImagePlacement imagePlacement;
                int imageHeight = nodePart.getImageHeight();
                if (imageHeight == 0) {
                    imageHeight = image.getImageData().height;
                }
                if ((imagePlacement = nodePart.getImagePlacement()) == ImagePlacement.TOP || imagePlacement == ImagePlacement.BOTTOM) {
                    int verticalSpacing = nodePart.getVerticalSpacing();
                    labelHeight = labelHeight + imageHeight + verticalSpacing;
                } else if (imagePlacement == ImagePlacement.LEFT || imagePlacement == ImagePlacement.RIGHT) {
                    labelHeight = Math.max(labelHeight, imageHeight);
                }
            } else {
                labelHeight += 16;
            }
            bounds.setHeight(labelHeight);
        }
        return bounds;
    }

    public Bounds getImageBounds(Bounds nodeBounds) {
        DiagramNodePart nodePart = this.getModelPart();
        int imageWidth = nodePart.getImageWidth();
        int imageHeight = nodePart.getImageHeight();
        Image image = this.getImage();
        if (image != null) {
            if (imageWidth == 0) {
                imageWidth = image.getImageData().width;
            }
            if (imageHeight == 0) {
                imageHeight = image.getImageData().height;
            }
        }
        int x = 0;
        int y = 0;
        ImagePlacement imagePlacement = nodePart.getImagePlacement();
        if (imagePlacement == ImagePlacement.LEFT) {
            x = 0;
            y = 0;
        } else if (imagePlacement == ImagePlacement.TOP) {
            int offsetX;
            x = offsetX = nodeBounds.getWidth() - imageWidth >> 1;
            y = 0;
        } else if (imagePlacement == ImagePlacement.BOTTOM) {
            int offsetX;
            int labelHeight = nodePart.getLabelHeight();
            int verticalSpacing = nodePart.getVerticalSpacing();
            x = offsetX = nodeBounds.getWidth() - imageWidth >> 1;
            y = labelHeight + verticalSpacing;
        } else if (imagePlacement == ImagePlacement.RIGHT) {
            int labelWidth = nodePart.getLabelWidth();
            int horizontalSpacing = nodePart.getHorizontalSpacing();
            x = labelWidth + horizontalSpacing;
            y = 0;
        }
        return new Bounds(x, y, imageWidth, imageHeight);
    }

    public Bounds getLabelBounds(Bounds nodeBounds) {
        DiagramNodePart nodePart = this.getModelPart();
        Image image = this.getImage();
        int imageWidth = 0;
        int imageHeight = 0;
        if (image != null) {
            imageWidth = nodePart.getImageWidth();
            if (imageWidth == 0) {
                imageWidth = image.getImageData().width;
            }
            if ((imageHeight = nodePart.getImageHeight()) == 0) {
                imageHeight = image.getImageData().height;
            }
        }
        int x = 0;
        int y = 0;
        int labelWidth = nodePart.getLabelWidth();
        int labelHeight = nodePart.getLabelHeight();
        labelWidth = labelWidth > 0 ? labelWidth : nodeBounds.getWidth();
        labelHeight = Math.max(labelHeight, 16);
        int verticalSpacing = nodePart.getVerticalSpacing();
        ImagePlacement imagePlacement = nodePart.getImagePlacement();
        if (imagePlacement == ImagePlacement.TOP) {
            x = 0;
            y = imageHeight + verticalSpacing;
        } else if (imagePlacement == ImagePlacement.BOTTOM) {
            x = 0;
            y = 0;
        } else if (imagePlacement == ImagePlacement.RIGHT) {
            x = 0;
            y = 0;
        } else if (imagePlacement == ImagePlacement.LEFT) {
            int horizontalSpacing = nodePart.getHorizontalSpacing();
            x = imageWidth + horizontalSpacing;
            y = 0;
        }
        int offset = nodeBounds.getHeight() - imageHeight - verticalSpacing - labelHeight >> 1;
        if (offset > 0) {
            y += offset;
        }
        return new Bounds(x + 2, y, labelWidth - 4, labelHeight);
    }

    public void handleMoveNode() {
        this.firePropertyChange(NODE_BOUNDS, null, this.getModelPart().getNodeBounds());
    }

    public void handleUpdateNode() {
        this.firePropertyChange(NODE_UPDATES, null, this.getModelPart().getNodeBounds());
    }

    public List<DiagramConnectionModel> getSourceConnections() {
        return this.sourceConnections;
    }

    public List<DiagramConnectionModel> getTargetConnections() {
        return this.targetConnections;
    }

    public void addSourceConnection(DiagramConnectionModel connection) {
        this.sourceConnections.add(connection);
        this.firePropertyChange(SOURCE_CONNECTIONS, null, connection);
    }

    public void addTargetConnection(DiagramConnectionModel connection) {
        this.targetConnections.add(connection);
        this.firePropertyChange(TARGET_CONNECTIONS, null, connection);
    }

    public void removeSourceConnection(DiagramConnectionModel connection) {
        this.sourceConnections.remove(connection);
        this.firePropertyChange(SOURCE_CONNECTIONS, null, connection);
    }

    public void removeTargetConnection(DiagramConnectionModel connection) {
        this.targetConnections.remove(connection);
        this.firePropertyChange(TARGET_CONNECTIONS, null, connection);
    }

    public void handleStartEditing() {
        this.firePropertyChange(NODE_START_EDITING, null, null);
    }

    public String toString() {
        return this.getLabel();
    }
}

