/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sapphire.ui.Color;
import org.eclipse.sapphire.ui.LineStyle;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class DiagramResourceCache {
    private List<org.eclipse.swt.graphics.Color> colors = new ArrayList<org.eclipse.swt.graphics.Color>();
    private Font defaultFont;

    public DiagramResourceCache() {
        FontDescriptor descriptor = JFaceResources.getDefaultFontDescriptor();
        FontData[] fontData = descriptor.getFontData();
        FontData smallerFontData = new FontData(fontData[0].getName(), fontData[0].getHeight() - 1, 0);
        this.defaultFont = new Font(null, new FontData[]{smallerFontData});
    }

    public int getLinkStyle(IDiagramConnectionDef def) {
        int linkStyle = 1;
        if (def != null) {
            LineStyle style = (LineStyle)def.getLineStyle().getContent();
            if (style == LineStyle.DASH) {
                linkStyle = 2;
            } else if (style == LineStyle.DOT) {
                linkStyle = 3;
            } else if (style == LineStyle.DASH_DOT) {
                linkStyle = 4;
            }
        }
        return linkStyle;
    }

    public org.eclipse.swt.graphics.Color getLineColor(DiagramConnectionPart connection) {
        IDiagramConnectionDef def = connection.getConnectionDef();
        org.eclipse.swt.graphics.Color color = ColorConstants.darkBlue;
        if (def != null) {
            return this.getColor((Color)def.getLineColor().getContent());
        }
        return color;
    }

    public org.eclipse.swt.graphics.Color getColor(Color sapphireColor) {
        int red = sapphireColor.getRed();
        int green = sapphireColor.getGreen();
        int blue = sapphireColor.getBlue();
        for (org.eclipse.swt.graphics.Color existingColor : this.colors) {
            if (existingColor.getRed() != red || existingColor.getGreen() != green || existingColor.getBlue() != blue) continue;
            return existingColor;
        }
        org.eclipse.swt.graphics.Color newColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), red, green, blue);
        this.colors.add(newColor);
        return newColor;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void dispose() {
        this.defaultFont.dispose();
        this.defaultFont = null;
        for (org.eclipse.swt.graphics.Color existingColor : this.colors) {
            existingColor.dispose();
        }
    }
}

