/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.policies;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.sapphire.ui.Color;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.swt.gef.commands.CreateConnectionCommand;
import org.eclipse.sapphire.ui.swt.gef.commands.ReconnectConnectionCommand;
import org.eclipse.sapphire.ui.swt.gef.figures.DiagramConnectionFigure;
import org.eclipse.sapphire.ui.swt.gef.figures.NodeFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionEditPart;

public class DiagramNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private static final Color DUMMY_CONNECTION_FOREGROUND = new Color(255, 153, 51);
    Rectangle rec;

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        CreateConnectionCommand cmd = (CreateConnectionCommand)request.getStartCommand();
        cmd.setTarget((DiagramNodeModel)this.getHost().getModel());
        return cmd;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        DiagramNodeModel source = (DiagramNodeModel)this.getHost().getModel();
        Object def = request.getNewObjectType();
        CreateConnectionCommand cmd = new CreateConnectionCommand(source, (IDiagramConnectionDef)def);
        request.setStartCommand((Command)cmd);
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        DiagramNodeModel newTarget = (DiagramNodeModel)this.getHost().getModel();
        DiagramConnectionEditPart editPart = (DiagramConnectionEditPart)request.getConnectionEditPart();
        ReconnectConnectionCommand cmd = new ReconnectConnectionCommand(editPart.getCastedModel());
        cmd.setNewTarget(newTarget);
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        DiagramNodeModel newSource = (DiagramNodeModel)this.getHost().getModel();
        DiagramConnectionEditPart editPart = (DiagramConnectionEditPart)request.getConnectionEditPart();
        ReconnectConnectionCommand cmd = new ReconnectConnectionCommand(editPart.getCastedModel());
        cmd.setNewSource(newSource);
        return cmd;
    }

    private void identifySourceFigure(Request req) {
        if (req instanceof CreateConnectionRequest) {
            CreateConnectionRequest r = (CreateConnectionRequest)req;
            if (r.getSourceEditPart() instanceof AbstractGraphicalEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)r.getSourceEditPart();
                this.rec = ep.getFigure().getBounds();
            }
        } else {
            this.rec = null;
        }
    }

    protected Connection createDummyConnection(Request req) {
        this.identifySourceFigure(req);
        IFigure hostFigure = this.getHostFigure();
        DummyPolylineConnection connection = new DummyPolylineConnection(hostFigure);
        connection.setLineWidth(2);
        connection.setLineStyle(2);
        if (hostFigure instanceof NodeFigure) {
            DiagramResourceCache cache = ((NodeFigure)hostFigure).getDiagramResourceCache();
            connection.setForegroundColor(cache.getColor(DUMMY_CONNECTION_FOREGROUND));
        }
        return connection;
    }

    private final class DummyPolylineConnection
    extends PolylineConnection {
        private IFigure hostFigure;

        DummyPolylineConnection(IFigure hostFigure) {
            this.setHostFigure(hostFigure);
        }

        public void paint(Graphics g) {
            if (DiagramNodeEditPolicy.this.rec != null && !(this.getHostFigure() instanceof DiagramConnectionFigure) && DiagramNodeEditPolicy.this.rec.contains(this.getPoints().getLastPoint())) {
                return;
            }
            g.setAntialias(1);
            super.paint(g);
        }

        private IFigure getHostFigure() {
            return this.hostFigure;
        }

        private void setHostFigure(IFigure hostFigure) {
            this.hostFigure = hostFigure;
        }
    }
}

