/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ListSelectionService;
import org.eclipse.sapphire.ui.PageBookPart;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartContainer;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PageBookExtDef;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireListControlledPageBook
extends PageBookPart {
    private IModelElement element;
    private ListProperty property;
    private boolean attached;

    @Override
    protected void init() {
        super.init();
        String pathString = (String)((PageBookExtDef)this.definition).getControlProperty().getContent();
        String pathStringSubstituted = SapphireListControlledPageBook.substituteParams(pathString, this.params);
        ModelPath path = new ModelPath(pathStringSubstituted);
        this.element = this.getLocalModelElement();
        int i = 0;
        int n = path.length();
        while (i < n) {
            ModelPath.Segment segment = path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = (IModelElement)this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.element.parent();
                if (!(parent instanceof IModelElement)) {
                    parent = parent.parent();
                }
                this.element = (IModelElement)parent;
            } else if (segment instanceof ModelPath.PropertySegment) {
                this.property = (ListProperty)this.resolve(this.element, ((ModelPath.PropertySegment)segment).getPropertyName());
                if (i + 1 != n) {
                    throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathString}));
                }
            } else {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object[])new Object[]{pathString}));
            }
            ++i;
        }
    }

    @Override
    protected Object parsePageKey(String pageKeyString) {
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        Class<?> cl = rootdef.resolveClass(pageKeyString);
        return PageBookPart.ClassBasedKey.create(cl);
    }

    @Override
    public void render(SapphireRenderingContext context) {
        super.render(context);
        if (!this.attached) {
            this.attached = true;
            PropertyEditorPart listPropertyEditorPart = this.findPropertyEditor(this, this.element, (ModelProperty)this.property);
            final ListSelectionService listSelectionService = listPropertyEditorPart.service(ListSelectionService.class);
            final MutableReference selectedModelElementRef = new MutableReference();
            final Listener listSelectionServiceListener = new Listener(){

                public void handle(Event event) {
                    PageBookPart.ClassBasedKey newPageKey;
                    IModelElement newModelElement;
                    List<IModelElement> selection = listSelectionService.selection();
                    if (!selection.isEmpty()) {
                        newModelElement = selection.get(0);
                        newPageKey = PageBookPart.ClassBasedKey.create(newModelElement);
                    } else {
                        newModelElement = SapphireListControlledPageBook.this.element;
                        newPageKey = null;
                    }
                    if (selectedModelElementRef.get() != newModelElement) {
                        selectedModelElementRef.set((Object)newModelElement);
                        Runnable inputChangeOperation = new Runnable(){

                            public void run() {
                                SapphireListControlledPageBook.this.changePage(newModelElement, newPageKey);
                            }
                        };
                        Display.getDefault().syncExec(inputChangeOperation);
                    }
                }
            };
            listSelectionService.attach(listSelectionServiceListener);
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        listSelectionService.detach(listSelectionServiceListener);
                    }
                }
            });
            this.changePage(this.element, null);
        }
    }

    private PropertyEditorPart findPropertyEditor(ISapphirePart part, IModelElement element, ModelProperty property) {
        return this.findPropertyEditor(part, element, property, (Set<ISapphirePart>)new IdentityHashSet());
    }

    private PropertyEditorPart findPropertyEditor(ISapphirePart part, IModelElement element, ModelProperty property, Set<ISapphirePart> searchedParts) {
        ISapphirePart parent;
        PropertyEditorPart propertyEditorPart;
        if (searchedParts.contains(part)) {
            return null;
        }
        if (part instanceof PropertyEditorPart && (propertyEditorPart = (PropertyEditorPart)part).getLocalModelElement() == element && propertyEditorPart.getProperty() == property) {
            return propertyEditorPart;
        }
        searchedParts.add(part);
        if (part instanceof SapphirePartContainer) {
            SapphirePartContainer partContainerPart = (SapphirePartContainer)part;
            for (SapphirePart sapphirePart : partContainerPart.getChildParts()) {
                PropertyEditorPart propertyEditorPart2 = this.findPropertyEditor(sapphirePart, element, property, searchedParts);
                if (propertyEditorPart2 == null) continue;
                return propertyEditorPart2;
            }
        }
        if ((parent = part.getParentPart()) != null) {
            return this.findPropertyEditor(parent, element, property, searchedParts);
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String invalidPath;

        static {
            Resources.initializeMessages((String)SapphireListControlledPageBook.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

