/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireModelCondition
extends SapphireCondition {
    private List<String> dependencies;
    private Listener listener;

    @Override
    protected void initCondition(ISapphirePart part, String parameter) {
        this.dependencies = this.getDependencies();
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            this.listener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    SapphireModelCondition.this.updateConditionState();
                }
            };
            IModelElement contextModelElement = part.getModelElement();
            for (String dependency : this.dependencies) {
                contextModelElement.attach(this.listener, dependency);
            }
        }
    }

    public List<String> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void dispose() {
        if (this.listener != null) {
            IModelElement contextModelElement = this.getPart().getModelElement();
            for (String dependency : this.dependencies) {
                contextModelElement.detach(this.listener, dependency);
            }
        }
    }
}

