/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.FormPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.FormDef;
import org.eclipse.sapphire.ui.def.PartDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphirePartContainer
extends FormPart {
    private List<SapphirePart> childParts;

    @Override
    protected void init() {
        super.init();
        List<SapphirePart> childPartsFromInit = this.initChildParts();
        this.childParts = Collections.unmodifiableList(new ArrayList<SapphirePart>(childPartsFromInit));
        Listener childPartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ValidationChangedEvent) {
                    SapphirePartContainer.this.updateValidationState();
                }
            }
        };
        for (SapphirePart childPart : this.childParts) {
            childPart.attach(childPartListener);
        }
        this.updateValidationState();
    }

    protected List<SapphirePart> initChildParts() {
        IModelElement element = this.getLocalModelElement();
        FormDef def = (FormDef)this.definition;
        ArrayList<SapphirePart> childParts = new ArrayList<SapphirePart>();
        for (PartDef childPartDef : def.getContent()) {
            SapphirePart childPart = SapphirePartContainer.create(this, element, childPartDef, this.params);
            childParts.add(childPart);
        }
        return childParts;
    }

    public List<? extends SapphirePart> getChildParts() {
        return this.childParts;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        for (SapphirePart sapphirePart : this.getChildParts()) {
            sapphirePart.render(context);
        }
    }

    @Override
    protected Status computeValidationState() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (SapphirePart sapphirePart : this.getChildParts()) {
            factory.merge(sapphirePart.getValidationState());
        }
        return factory.create();
    }

    @Override
    public boolean setFocus() {
        for (SapphirePart sapphirePart : this.getChildParts()) {
            if (!sapphirePart.setFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        for (SapphirePart sapphirePart : this.getChildParts()) {
            if (!sapphirePart.setFocus(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart sapphirePart : this.getChildParts()) {
            sapphirePart.dispose();
        }
    }
}

