/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.help.IContext;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireHelpContext;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class SapphireRenderingContext {
    private final ISapphirePart part;
    private final SapphireRenderingContext parent;
    protected Shell shell;
    protected Composite composite;

    public SapphireRenderingContext(ISapphirePart part, Composite composite) {
        this(part, null, composite);
    }

    public SapphireRenderingContext(ISapphirePart part, SapphireRenderingContext parent, Composite composite) {
        this.part = part;
        this.parent = parent;
        this.shell = composite.getShell();
        this.composite = composite;
    }

    public SapphireRenderingContext(ISapphirePart part, Shell shell) {
        this.part = part;
        this.parent = null;
        this.shell = shell;
        this.composite = null;
    }

    public ISapphirePart getPart() {
        return this.part;
    }

    public final SapphireImageCache getImageCache() {
        return this.getPart().getImageCache();
    }

    public Shell getShell() {
        return this.shell;
    }

    public Display getDisplay() {
        return this.shell.getDisplay();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void layout() {
        if (this.parent == null) {
            Composite composite = this.composite;
            while (composite != null) {
                if (composite instanceof SharedScrolledComposite) {
                    composite.getShell().layout(true, true);
                    ((SharedScrolledComposite)composite).reflow(true);
                    return;
                }
                if (composite instanceof Shell) {
                    composite.layout(true, true);
                    return;
                }
                composite = composite.getParent();
            }
        } else {
            this.parent.layout();
        }
    }

    public void adapt(Control control) {
        if (this.parent != null) {
            this.parent.adapt(control);
        }
    }

    public final void setHelp(Control control, IModelElement modelElement, ModelProperty property) {
        final SapphireHelpContext context = new SapphireHelpContext(modelElement, property);
        if (context.getText() != null || context.getRelatedTopics() != null && context.getRelatedTopics().length > 0) {
            control.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    Point point = SapphireHelpSystem.computePopUpLocation(event.widget.getDisplay());
                    PlatformUI.getWorkbench().getHelpSystem().displayContext((IContext)context, point.x, point.y);
                }
            });
        }
    }
}

