/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class ResetActionsAssistContributor
extends PropertyEditorAssistContributor {
    public ResetActionsAssistContributor() {
        this.setId("System.ResetActionsContributor");
        this.setPriority(310);
    }

    public void contribute(PropertyEditorAssistContext context) {
        ModelElementHandle handle;
        final IModelElement element = context.getModelElement();
        final ModelProperty prop = context.getProperty();
        if (context.isPropertyEditorReadOnly()) {
            return;
        }
        if (prop instanceof ValueProperty) {
            Value val = element.read((ValueProperty)prop);
            if (val.getText(false) != null) {
                DefaultValueService defaultValueService = (DefaultValueService)element.service(prop, DefaultValueService.class);
                boolean hasDefaultValue = defaultValueService == null ? false : defaultValueService.value() != null;
                boolean isBooleanType = prop.getTypeClass().equals(Boolean.class);
                String actionText = hasDefaultValue || isBooleanType ? Resources.restoreDefaultValue : Resources.clear;
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(actionText) + "</a></p>");
                contribution.link("action", new Runnable(){

                    public void run() {
                        element.write((ValueProperty)prop, null);
                    }
                });
                PropertyEditorAssistSection section = context.getSection("actions");
                section.addContribution(contribution.create());
            }
        } else if (prop instanceof ListProperty) {
            final ModelElementList list = element.read((ListProperty)prop);
            if (!list.isEmpty()) {
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(Resources.clear) + "</a></p>");
                contribution.link("action", new Runnable(){

                    public void run() {
                        list.clear();
                    }
                });
                PropertyEditorAssistSection section = context.getSection("actions");
                section.addContribution(contribution.create());
            }
        } else if (prop instanceof ElementProperty && (handle = element.read((ElementProperty)prop)).element() != null) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(Resources.clear) + "</a></p>");
            contribution.link("action", new Runnable(){

                public void run() {
                    handle.remove();
                }
            });
            PropertyEditorAssistSection section = context.getSection("actions");
            section.addContribution(contribution.create());
        }
    }

    private static final class Resources
    extends NLS {
        public static String restoreDefaultValue;
        public static String clear;

        static {
            Resources.initializeMessages((String)ResetActionsAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

