/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public final class RestoreInitialValueActionsAssistContributor
extends PropertyEditorAssistContributor {
    public RestoreInitialValueActionsAssistContributor() {
        this.setId("System.RestoreInitialValueActionsContributor");
        this.setPriority(315);
    }

    public void contribute(PropertyEditorAssistContext context) {
        ValueProperty prop;
        InitialValueService initialValueService;
        final IModelElement element = context.getModelElement();
        ModelProperty property = context.getProperty();
        if (property.isReadOnly()) {
            return;
        }
        if (property instanceof ValueProperty && (initialValueService = (InitialValueService)element.service((ModelProperty)(prop = (ValueProperty)property), InitialValueService.class)) != null) {
            final String initialValue = initialValueService.value();
            String currentValue = element.read(prop).getText(false);
            if (initialValue != null && !initialValue.equals(currentValue)) {
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + RestoreInitialValueActionsAssistContributor.escapeForXml(Resources.restore) + "</a></p>");
                contribution.link("action", new Runnable(){

                    public void run() {
                        element.write(prop, (Object)initialValue);
                    }
                });
                PropertyEditorAssistSection section = context.getSection("actions");
                section.addContribution(contribution.create());
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String restore;

        static {
            Resources.initializeMessages((String)RestoreInitialValueActionsAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

