/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import java.net.URL;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ClassLocator;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceLocator;
import org.eclipse.sapphire.modeling.ResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.SharedModelsCache;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.osgi.BundleResourceStore;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardDef;

public final class SapphireUiDefFactory {
    public static ISapphireUiDef load(String bundleId, String path) {
        try {
            return SapphireUiDefFactory.load(new XmlResourceStore((ByteArrayResourceStore)new BundleResourceStore(bundleId, path)), false);
        }
        catch (ResourceStoreException e) {
            LoggingService.log((Exception)((Object)e));
            return null;
        }
    }

    public static ISapphireUiDef load(ISapphireUiDef context, String path) {
        URL url;
        final ResourceLocator resourceLocator = (ResourceLocator)context.adapt(ResourceLocator.class);
        if (resourceLocator != null && (url = resourceLocator.find(path)) != null) {
            final ClassLocator classLocator = (ClassLocator)context.adapt(ClassLocator.class);
            try {
                UrlResourceStore resourceStore = new UrlResourceStore(url){

                    public <A> A adapt(Class<A> adapterType) {
                        if (adapterType == ResourceLocator.class) {
                            return adapterType.cast(resourceLocator);
                        }
                        if (adapterType == ClassLocator.class) {
                            return adapterType.cast(classLocator);
                        }
                        return (A)super.adapt(adapterType);
                    }
                };
                return SapphireUiDefFactory.load(new XmlResourceStore((ByteArrayResourceStore)resourceStore), false);
            }
            catch (ResourceStoreException e) {
                LoggingService.log((Exception)((Object)e));
            }
        }
        return null;
    }

    public static ISapphireUiDef load(XmlResourceStore resourceStore, boolean writable) {
        ISapphireUiDef model;
        if (writable || Sapphire.isDevMode()) {
            model = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
        } else {
            SharedModelsCache.StandardKey key = new SharedModelsCache.StandardKey((ResourceStore)resourceStore, ISapphireUiDef.TYPE);
            model = (ISapphireUiDef)SharedModelsCache.retrieve((Object)key);
            if (model == null) {
                model = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
                SharedModelsCache.store((Object)key, (IModelElement)model);
            }
        }
        return model;
    }

    public static ISapphireCompositeDef getCompositeDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getCompositeDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireCompositeDef getCompositeDef(String bundleId, String defFilePath, String compositeId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return (ISapphireCompositeDef)def.getPartDef(compositeId, true, ISapphireCompositeDef.class);
    }

    public static ISapphireDialogDef getDialogDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getDialogDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireDialogDef getDialogDef(String bundleId, String defFilePath, String wizardId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return (ISapphireDialogDef)def.getPartDef(wizardId, true, ISapphireDialogDef.class);
    }

    public static ISapphireWizardDef getWizardDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getWizardDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireWizardDef getWizardDef(String bundleId, String defFilePath, String wizardId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return (ISapphireWizardDef)def.getPartDef(wizardId, true, ISapphireWizardDef.class);
    }

    private static String[] parseDefPath(String path) {
        int firstSeparator = path.indexOf(47);
        int secondSeparator = path.lastIndexOf(33);
        int lastIndex = path.length() - 1;
        if (firstSeparator <= 0 || firstSeparator >= lastIndex || secondSeparator <= 0 || secondSeparator >= lastIndex || firstSeparator > secondSeparator) {
            throw new IllegalArgumentException();
        }
        String bundleId = path.substring(0, firstSeparator);
        String defFilePath = path.substring(firstSeparator + 1, secondSeparator);
        String compositeId = path.substring(secondSeparator + 1);
        return new String[]{bundleId, defFilePath, compositeId};
    }
}

