/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.ListUtil;
import org.eclipse.sapphire.ui.diagram.editor.ModelUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramConnectionTemplate
extends SapphirePart {
    protected SapphireDiagramEditorPagePart diagramEditor;
    protected IDiagramConnectionDef connectionDef;
    protected IDiagramExplicitConnectionBindingDef bindingDef;
    protected IModelElement modelElement;
    protected String propertyName;
    private ListProperty modelProperty;
    protected ListProperty connListProperty;
    protected Listener modelPropertyListener;
    protected SapphireDiagramPartListener connPartListener;
    protected Set<DiagramConnectionTemplateListener> templateListeners;
    private ModelPath originalEndpoint2Path;
    private ModelPath endpoint1Path;
    private ModelPath endpoint2Path;
    private ModelProperty endpoint1Property;
    private ModelProperty endpoint2Property;
    private List<DiagramConnectionPart> diagramConnections = new ArrayList<DiagramConnectionPart>();

    public DiagramConnectionTemplate() {
    }

    public DiagramConnectionTemplate(IDiagramExplicitConnectionBindingDef bindingDef) {
        this.bindingDef = bindingDef;
    }

    @Override
    public void init() {
        this.diagramEditor = (SapphireDiagramEditorPagePart)this.getParentPart();
        this.modelElement = this.getModelElement();
        this.connectionDef = (IDiagramConnectionDef)super.definition();
        this.propertyName = (String)this.bindingDef.getProperty().getContent();
        this.modelProperty = (ListProperty)ModelUtil.resolve(this.modelElement, this.propertyName);
        this.connPartListener = new ConnectionPartListener();
        this.templateListeners = new CopyOnWriteArraySet<DiagramConnectionTemplateListener>();
        String endpt1PropStr = (String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().element()).getProperty().getContent();
        String endpt2PropStr = (String)((IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element()).getProperty().getContent();
        this.originalEndpoint2Path = new ModelPath(endpt2PropStr);
        ModelElementType type = this.modelProperty.getType();
        this.endpoint1Property = type.property(endpt1PropStr);
        this.endpoint2Property = ModelUtil.resolve(type, this.originalEndpoint2Path);
        if (this.getConnectionType() == ConnectionType.OneToOne) {
            this.endpoint1Path = new ModelPath(endpt1PropStr);
            this.endpoint2Path = new ModelPath(endpt2PropStr);
            this.connListProperty = this.modelProperty;
        } else {
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            ModelProperty prop = type.property(head.getPropertyName());
            if (prop instanceof ListProperty) {
                this.endpoint1Path = new ModelPath("../" + endpt1PropStr);
                this.endpoint2Path = this.originalEndpoint2Path.tail();
                this.connListProperty = (ListProperty)prop;
            } else {
                throw new RuntimeException("Invaid Model Path:" + this.originalEndpoint2Path);
            }
        }
        ModelElementList list = this.modelElement.read(this.modelProperty);
        for (IModelElement listEntryModelElement : list) {
            if (this.getConnectionType() == ConnectionType.OneToOne) {
                this.createNewConnectionPart(listEntryModelElement, null);
                continue;
            }
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            ModelProperty connProp = ModelUtil.resolve(listEntryModelElement, head.getPropertyName());
            if (!(connProp instanceof ListProperty)) {
                throw new RuntimeException("Expecting " + connProp.getName() + " to be a list property");
            }
            ModelElementList connList = listEntryModelElement.read((ListProperty)connProp);
            for (IModelElement connElement : connList) {
                this.createNewConnectionPart(connElement, null);
            }
        }
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramConnectionTemplate.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
    }

    public String getConnectionId() {
        return (String)this.bindingDef.getConnectionId().getContent();
    }

    public String getConnectionTypeId() {
        return (String)this.connectionDef.getId().getContent();
    }

    public List<DiagramConnectionPart> getDiagramConnections(IModelElement connListParent) {
        ArrayList<DiagramConnectionPart> connList = new ArrayList<DiagramConnectionPart>();
        if (connListParent == null || this.getConnectionType() == ConnectionType.OneToOne) {
            connList.addAll(this.diagramConnections);
        } else {
            for (DiagramConnectionPart connPart : this.diagramConnections) {
                IModelElement connModel = connPart.getLocalModelElement();
                if (connModel.parent().parent() != connListParent) continue;
                connList.add(connPart);
            }
        }
        return connList;
    }

    public IModelElement getConnectionParentElement(IModelElement srcNodeModel) {
        if (this.getConnectionType() == ConnectionType.OneToMany) {
            ModelElementList list = this.modelElement.read(this.modelProperty);
            for (IModelElement listEntryModelElement : list) {
                SapphireDiagramEditorPagePart diagramEditorPart;
                DiagramNodePart targetNode;
                Object valObj = listEntryModelElement.read(this.endpoint1Property);
                if (!(valObj instanceof ReferenceValue)) continue;
                ReferenceValue reference = (ReferenceValue)valObj;
                IModelElement model = (IModelElement)reference.resolve();
                if (model == null && reference.getText() != null && (targetNode = IdUtil.getNodePart(diagramEditorPart = this.getDiagramEditor(), reference.getText())) != null) {
                    model = targetNode.getLocalModelElement();
                }
                if (srcNodeModel != model) continue;
                return listEntryModelElement;
            }
        }
        return null;
    }

    public boolean canStartNewConnection(DiagramNodePart srcNode) {
        boolean canStart = false;
        ModelElementType srcType = srcNode.getModelElement().type();
        if (this.endpoint1Property.getType() == null && this.endpoint1Property.hasAnnotation(Reference.class)) {
            canStart = ((Reference)this.endpoint1Property.getAnnotation(Reference.class)).target().isAssignableFrom(srcType.getModelElementClass());
        }
        return canStart;
    }

    public boolean canCreateNewConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        boolean canCreate = false;
        canCreate = this.canStartNewConnection(srcNode);
        if (!canCreate) {
            return false;
        }
        ModelElementType targetType = targetNode.getModelElement().type();
        if (this.endpoint2Property.getType() == null && this.endpoint2Property.hasAnnotation(Reference.class)) {
            canCreate = ((Reference)this.endpoint2Property.getAnnotation(Reference.class)).target().isAssignableFrom(targetType.getModelElementClass());
        }
        return canCreate;
    }

    public void addModelListener() {
        this.modelElement.attach(this.modelPropertyListener, this.propertyName);
        if (this.getConnectionType() == ConnectionType.OneToMany) {
            ModelElementList list = this.modelElement.read(this.modelProperty);
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            for (IModelElement listEntryModelElement : list) {
                listEntryModelElement.attach(this.modelPropertyListener, head.getPropertyName());
            }
        }
    }

    public void removeModelListener() {
        this.modelElement.detach(this.modelPropertyListener, this.propertyName);
        if (this.getConnectionType() == ConnectionType.OneToMany) {
            ModelElementList list = this.modelElement.read(this.modelProperty);
            for (IModelElement listEntryModelElement : list) {
                ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
                listEntryModelElement.detach(this.modelPropertyListener, head.getPropertyName());
            }
        }
    }

    public void addTemplateListener(DiagramConnectionTemplateListener listener) {
        this.templateListeners.add(listener);
    }

    public void removeTemplateListener(DiagramConnectionTemplateListener listener) {
        this.templateListeners.remove(listener);
    }

    public SapphireDiagramEditorPagePart getDiagramEditor() {
        return this.diagramEditor;
    }

    public ConnectionType getConnectionType() {
        if (this.originalEndpoint2Path.length() > 1) {
            return ConnectionType.OneToMany;
        }
        return ConnectionType.OneToOne;
    }

    public String getSerializedEndpoint1(DiagramNodePart srcNode) {
        String endpoint1Value = null;
        IDiagramConnectionEndpointBindingDef srcAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().element();
        Value<Function> srcFunc = srcAnchorDef.getValue();
        FunctionResult srcFuncResult = this.getNodeReferenceFunction(srcNode, srcFunc, (LocalizationService)this.bindingDef.adapt(LocalizationService.class));
        if (srcFuncResult != null) {
            endpoint1Value = (String)srcFuncResult.value();
            srcFuncResult.dispose();
        }
        if (endpoint1Value == null || endpoint1Value.length() == 0) {
            endpoint1Value = IdUtil.computeNodeId(srcNode);
        }
        return endpoint1Value;
    }

    public String getSerializedEndpoint2(DiagramNodePart targetNode) {
        String endpoint2Value = null;
        IDiagramConnectionEndpointBindingDef targetAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element();
        Value<Function> targetFunc = targetAnchorDef.getValue();
        FunctionResult targetFuncResult = this.getNodeReferenceFunction(targetNode, targetFunc, (LocalizationService)this.bindingDef.adapt(LocalizationService.class));
        if (targetFuncResult != null) {
            endpoint2Value = (String)targetFuncResult.value();
            targetFuncResult.dispose();
        }
        if (endpoint2Value == null || endpoint2Value.length() == 0) {
            endpoint2Value = IdUtil.computeNodeId(targetNode);
        }
        return endpoint2Value;
    }

    private IModelElement getOneToManyConnectionSrcElement(String endpoint1Value) {
        ModelElementList list = this.modelElement.read(this.modelProperty);
        IModelElement srcElement = null;
        for (IModelElement element : list) {
            Object valObj = element.read(this.endpoint1Property);
            String val = null;
            val = valObj instanceof ReferenceValue ? ((ReferenceValue)valObj).getText() : (String)valObj;
            if (val == null || !val.equals(endpoint1Value)) continue;
            srcElement = element;
            break;
        }
        return srcElement;
    }

    public void setSerializedEndpoint1(IModelElement connModelElement, String endpoint1Value) {
        IDiagramConnectionEndpointBindingDef srcAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().element();
        if (this.getConnectionType() == ConnectionType.OneToOne) {
            this.setModelProperty(connModelElement, ((ModelPath.PropertySegment)this.endpoint1Path.head()).getPropertyName(), endpoint1Value);
        } else {
            IModelElement srcElement = this.getOneToManyConnectionSrcElement(endpoint1Value);
            if (srcElement != null) {
                String srcProperty = (String)srcAnchorDef.getProperty().getContent();
                this.setModelProperty(srcElement, srcProperty, endpoint1Value);
            }
        }
    }

    public void setSerializedEndpoint2(IModelElement connModelElement, String endpoint2Value) {
        if (this.getConnectionType() == ConnectionType.OneToOne) {
            this.setModelProperty(connModelElement, ((ModelPath.PropertySegment)this.endpoint2Path.head()).getPropertyName(), endpoint2Value);
        } else {
            this.setModelProperty(connModelElement, ((ModelPath.PropertySegment)this.endpoint2Path.head()).getPropertyName(), endpoint2Value);
        }
    }

    public DiagramConnectionPart createNewDiagramConnection(DiagramNodePart srcNode, DiagramNodePart targetNode) {
        String endpoint1Value = this.getSerializedEndpoint1(srcNode);
        String endpoint2Value = this.getSerializedEndpoint2(targetNode);
        if (endpoint1Value != null && endpoint2Value != null) {
            ModelPath.PropertySegment head;
            ModelProperty connProp;
            if (this.getConnectionType() == ConnectionType.OneToOne) {
                ModelElementList list = this.modelElement.read(this.modelProperty);
                IModelElement newElement = list.insert();
                this.setModelProperty(newElement, ((ModelPath.PropertySegment)this.endpoint1Path.head()).getPropertyName(), endpoint1Value);
                this.setModelProperty(newElement, ((ModelPath.PropertySegment)this.endpoint2Path.head()).getPropertyName(), endpoint2Value);
                DiagramConnectionPart newConn = this.getConnectionPart(srcNode.getModelElement(), newElement);
                if (newConn == null) {
                    newConn = this.createNewConnectionPart(newElement, null);
                }
                return newConn;
            }
            IModelElement srcElement = this.getOneToManyConnectionSrcElement(endpoint1Value);
            IDiagramConnectionEndpointBindingDef srcAnchorDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().element();
            String srcProperty = (String)srcAnchorDef.getProperty().getContent();
            if (srcElement == null) {
                ModelElementList list = this.modelElement.read(this.modelProperty);
                srcElement = list.insert();
                this.setModelProperty(srcElement, srcProperty, endpoint1Value);
            }
            if (!((connProp = ModelUtil.resolve(srcElement, (head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head()).getPropertyName())) instanceof ListProperty)) {
                throw new RuntimeException("Expecting " + connProp.getName() + " to be a list property");
            }
            ModelElementList connList = srcElement.read((ListProperty)connProp);
            IModelElement newElement = connList.insert();
            this.setModelProperty(newElement, ((ModelPath.PropertySegment)this.endpoint2Path.head()).getPropertyName(), endpoint2Value);
            DiagramConnectionPart newConn = this.getConnectionPart(srcElement, newElement);
            if (newConn == null) {
                newConn = this.createNewConnectionPart(newElement, null);
            }
            return newConn;
        }
        return null;
    }

    public DiagramConnectionPart createNewConnectionPart(IModelElement connElement, IModelElement srcNodeElement) {
        DiagramConnectionPart connPart = new DiagramConnectionPart(this.bindingDef, this.endpoint1Path, this.endpoint2Path);
        connPart.init(this, connElement, this.connectionDef, Collections.<String, String>emptyMap());
        connPart.addListener(this.connPartListener);
        this.addConnectionPart(srcNodeElement, connPart);
        return connPart;
    }

    public void showAllConnectionParts(DiagramNodeTemplate nodeTemplate) {
        List<DiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (DiagramConnectionPart connPart : connParts) {
            IModelElement endpt1 = connPart.getEndpoint1();
            IModelElement endpt2 = connPart.getEndpoint2();
            DiagramNodePart nodePart1 = this.diagramEditor.getDiagramNodePart(endpt1);
            if (nodePart1 != null && nodePart1.getDiagramNodeTemplate() == nodeTemplate) {
                this.notifyConnectionAdd(new DiagramConnectionEvent(connPart));
                continue;
            }
            DiagramNodePart nodePart2 = this.diagramEditor.getDiagramNodePart(endpt2);
            if (nodePart2 == null || nodePart2.getDiagramNodeTemplate() != nodeTemplate) continue;
            this.notifyConnectionAdd(new DiagramConnectionEvent(connPart));
        }
    }

    protected void setModelProperty(IModelElement modelElement, String propertyName, Object value) {
        if (propertyName != null) {
            ModelElementType type = modelElement.type();
            ModelProperty property = type.property(propertyName);
            if (property == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            if (!(property instanceof ValueProperty)) {
                throw new RuntimeException("Property " + propertyName + " not a ValueProperty");
            }
            modelElement.write((ValueProperty)property, value);
        }
    }

    protected FunctionResult getNodeReferenceFunction(DiagramNodePart nodePart, Value<Function> function, LocalizationService ls) {
        Function f = null;
        FunctionResult fr = null;
        if (function != null) {
            f = (Function)function.getContent();
        }
        if (f != null) {
            f = FailSafeFunction.create((Function)f, (Function)Literal.create(String.class));
            fr = f.evaluate((FunctionContext)new ModelElementFunctionContext(nodePart.getLocalModelElement(), ls));
        }
        return fr;
    }

    protected void handleConnectionListChange(IModelElement connListParent, ListProperty listProperty) {
        DiagramConnectionPart connPart;
        ModelElementList newList = connListParent.read(listProperty);
        List<DiagramConnectionPart> connParts = this.getDiagramConnections(connListParent);
        ArrayList<IModelElement> oldList = new ArrayList<IModelElement>(connParts.size());
        for (DiagramConnectionPart connPart2 : connParts) {
            oldList.add(connPart2.getLocalModelElement());
        }
        List<IModelElement> deletedConns = ListUtil.ListDiff(oldList, (List<? extends IModelElement>)newList);
        List<IModelElement> newConns = ListUtil.ListDiff((List<? extends IModelElement>)newList, oldList);
        for (IModelElement deletedConn : deletedConns) {
            connPart = this.getConnectionPart(connListParent, deletedConn);
            if (connPart == null) continue;
            this.notifyConnectionDelete(new DiagramConnectionEvent(connPart));
            this.disposeConnectionPart(connPart);
        }
        for (IModelElement newConn : newConns) {
            connPart = this.createNewConnectionPart(newConn, connListParent);
            if (connPart.getEndpoint1() != null && connPart.getEndpoint2() != null) {
                this.notifyConnectionAdd(new DiagramConnectionEvent(connPart));
                continue;
            }
            this.disposeConnectionPart(connPart);
        }
    }

    protected void handleModelPropertyChange(PropertyEvent event) {
        IModelElement element = event.element();
        ListProperty property = (ListProperty)event.property();
        ModelElementList newList = element.read(property);
        if (property == this.connListProperty) {
            this.handleConnectionListChange(element, property);
        } else if (property == this.modelProperty) {
            List<DiagramConnectionPart> connParts = this.getDiagramConnections(null);
            ArrayList<IModelElement> oldList = new ArrayList<IModelElement>();
            HashSet<IModelElement> oldConnParents = new HashSet<IModelElement>();
            for (DiagramConnectionPart connPart : connParts) {
                IModelElement connElement = connPart.getLocalModelElement();
                IModelElement connParentElement = (IModelElement)connElement.parent().parent();
                if (oldConnParents.contains(connParentElement)) continue;
                oldConnParents.add(connParentElement);
            }
            Iterator it = oldConnParents.iterator();
            while (it.hasNext()) {
                oldList.add((IModelElement)it.next());
            }
            List<IModelElement> deletedConnParents = ListUtil.ListDiff(oldList, (List<? extends IModelElement>)newList);
            List<IModelElement> newConnParents = ListUtil.ListDiff((List<? extends IModelElement>)newList, oldList);
            ArrayList<DiagramConnectionPart> connPartsCopy = new ArrayList<DiagramConnectionPart>(connParts.size());
            connPartsCopy.addAll(connParts);
            for (DiagramConnectionPart connPart : connPartsCopy) {
                IModelElement connElement = connPart.getLocalModelElement();
                IModelElement connParentElement = (IModelElement)connElement.parent().parent();
                if (!deletedConnParents.contains(connParentElement)) continue;
                this.notifyConnectionDelete(new DiagramConnectionEvent(connPart));
                this.disposeConnectionPart(connPart);
            }
            ModelPath.PropertySegment head = (ModelPath.PropertySegment)this.originalEndpoint2Path.head();
            for (IModelElement newConnParent : newConnParents) {
                newConnParent.attach(this.modelPropertyListener, head.getPropertyName());
                this.handleConnectionListChange(newConnParent, this.connListProperty);
            }
        }
    }

    public void addConnectionPart(IModelElement srcNodeModel, DiagramConnectionPart connPart) {
        this.diagramConnections.add(connPart);
    }

    public void disposeConnectionPart(DiagramConnectionPart connPart) {
        connPart.dispose();
        this.diagramConnections.remove(connPart);
    }

    protected DiagramConnectionPart getConnectionPart(IModelElement srcNodeModel, IModelElement connModel) {
        List<DiagramConnectionPart> connParts = this.getDiagramConnections(srcNodeModel);
        for (DiagramConnectionPart connPart : connParts) {
            if (!connPart.getLocalModelElement().equals(connModel)) continue;
            return connPart;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.removeModelListener();
        List<DiagramConnectionPart> connParts = this.getDiagramConnections(null);
        for (DiagramConnectionPart connPart : connParts) {
            this.notifyConnectionDelete(new DiagramConnectionEvent(connPart));
            connPart.dispose();
        }
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    protected void notifyConnectionUpdate(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionUpdate(event);
        }
    }

    protected void notifyConnectionEndpointUpdate(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionEndpointUpdate(event);
        }
    }

    public void notifyConnectionAdd(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionAdd(event);
        }
    }

    protected void notifyConnectionDelete(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionDelete(event);
        }
    }

    protected void notifyAddBendpoint(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleAddBendpoint(event);
        }
    }

    protected void notifyRemoveBendpoint(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleRemoveBendpoint(event);
        }
    }

    protected void notifyMoveBendpoint(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleMoveBendpoint(event);
        }
    }

    protected void notifyResetBendpoints(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleResetBendpoints(event);
        }
    }

    protected void notifyMoveLabel(DiagramConnectionEvent event) {
        for (DiagramConnectionTemplateListener listener : this.templateListeners) {
            listener.handleMoveLabel(event);
        }
    }

    protected class ConnectionPartListener
    extends SapphireDiagramPartListener {
        protected ConnectionPartListener() {
        }

        public void handleConnectionUpdateEvent(DiagramConnectionEvent event) {
            DiagramConnectionTemplate.this.notifyConnectionUpdate(event);
        }

        public void handleConnectionEndpointEvent(DiagramConnectionEvent event) {
            DiagramConnectionTemplate.this.notifyConnectionEndpointUpdate(event);
        }

        public void handleConnectionAddBendpointEvent(DiagramConnectionEvent event) {
            DiagramConnectionTemplate.this.notifyAddBendpoint(event);
        }

        public void handleConnectionRemoveBendpointEvent(DiagramConnectionEvent event) {
            DiagramConnectionTemplate.this.notifyRemoveBendpoint(event);
        }

        public void handleConnectionMoveBendpointEvent(DiagramConnectionEvent event) {
            DiagramConnectionTemplate.this.notifyMoveBendpoint(event);
        }

        public void handleConnectionResetBendpointsEvent(DiagramConnectionEvent event) {
            DiagramConnectionTemplate.this.notifyResetBendpoints(event);
        }

        public void handleConnectionMoveLabelEvent(DiagramConnectionEvent event) {
            DiagramConnectionTemplate.this.notifyMoveLabel(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        OneToOne,
        OneToMany;

    }

    public static abstract class DiagramConnectionTemplateListener {
        public void handleConnectionUpdate(DiagramConnectionEvent event) {
        }

        public void handleConnectionEndpointUpdate(DiagramConnectionEvent event) {
        }

        public void handleConnectionAdd(DiagramConnectionEvent event) {
        }

        public void handleConnectionDelete(DiagramConnectionEvent event) {
        }

        public void handleAddBendpoint(DiagramConnectionEvent event) {
        }

        public void handleRemoveBendpoint(DiagramConnectionEvent event) {
        }

        public void handleMoveBendpoint(DiagramConnectionEvent event) {
        }

        public void handleResetBendpoints(DiagramConnectionEvent event) {
        }

        public void handleMoveLabel(DiagramConnectionEvent event) {
        }
    }
}

