/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsContentNodeDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsEditorPageDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.state.ContentOutlineNodeState;
import org.eclipse.sapphire.ui.form.editors.masterdetails.state.MasterDetailsEditorPageState;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.util.ReadOnlyListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsContentOutline {
    private final MasterDetailsEditorPagePart editorPagePart;
    private final IMasterDetailsEditorPageDef editorPageDef;
    private final IModelElement rootModelElement;
    private MasterDetailsContentNode root;
    private List<MasterDetailsContentNode> selection;
    private final ListenerContext listeners;
    private String filterText;

    public MasterDetailsContentOutline(MasterDetailsEditorPagePart editorPagePart) {
        this.editorPagePart = editorPagePart;
        this.editorPageDef = editorPagePart.definition();
        this.rootModelElement = editorPagePart.getModelElement();
        this.selection = Collections.emptyList();
        this.listeners = new ListenerContext();
        this.filterText = "";
    }

    public MasterDetailsContentNode getRoot() {
        if (this.root == null) {
            IMasterDetailsContentNodeDef rootNodeDef = this.editorPageDef.getRootNode();
            this.root = new MasterDetailsContentNode();
            this.root.init(this.editorPagePart, this.rootModelElement, rootNodeDef, Collections.<String, String>emptyMap());
            this.loadTreeState();
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof NodeExpandedStateChangedEvent || event instanceof SelectionChangedEvent) {
                        MasterDetailsContentOutline.this.saveTreeState();
                    } else if (event instanceof NodeStructureChangedEvent) {
                        MasterDetailsContentOutline.this.handleNodeStructureChange();
                    }
                }
            });
        }
        return this.root;
    }

    public MasterDetailsContentNode getSelectedNode() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    public List<MasterDetailsContentNode> getSelectedNodes() {
        return this.selection;
    }

    public void setSelectedNode(MasterDetailsContentNode selection) {
        if (selection == null) {
            this.setSelectedNodes(Collections.<MasterDetailsContentNode>emptyList());
        } else {
            this.setSelectedNodes(Collections.singletonList(selection));
        }
    }

    public void setSelectedNodes(List<MasterDetailsContentNode> selection) {
        if (!this.selection.equals(selection)) {
            for (MasterDetailsContentNode node : selection) {
                MasterDetailsContentNode parent = node.getParentNode();
                if (parent == null) continue;
                parent.setExpanded(true);
            }
            this.selection = selection.isEmpty() ? Collections.emptyList() : new ArrayList<MasterDetailsContentNode>(selection);
            this.listeners.broadcast((Event)new SelectionChangedEvent(this.selection));
        }
    }

    public void setSelection(String path) {
        MasterDetailsContentNode node = this.root;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            boolean segmentMatched = false;
            for (MasterDetailsContentNode n3 : node.getChildNodes()) {
                if (!n3.getLabel().equals(segment)) continue;
                node = n3;
                segmentMatched = true;
                break;
            }
            if (!segmentMatched) break;
            ++n2;
        }
        if (node != this.root) {
            this.setSelectedNode(node);
        }
    }

    public List<MasterDetailsContentNode> getExpandedNodes() {
        ArrayList<MasterDetailsContentNode> result = new ArrayList<MasterDetailsContentNode>();
        for (MasterDetailsContentNode node : this.root.getChildNodes()) {
            node.getExpandedNodes(result);
        }
        return result;
    }

    public void setExpandedNodes(Set<MasterDetailsContentNode> expandedNodes) {
        for (MasterDetailsContentNode node : this.root.getChildNodes()) {
            MasterDetailsContentOutline.setExpandedNodes(node, expandedNodes);
        }
    }

    private static void setExpandedNodes(MasterDetailsContentNode node, Set<MasterDetailsContentNode> expandedNodes) {
        for (MasterDetailsContentNode child : node.getChildNodes()) {
            MasterDetailsContentOutline.setExpandedNodes(child, expandedNodes);
        }
        boolean shouldBeExpanded = expandedNodes.contains(node);
        if (node.isExpanded() != shouldBeExpanded) {
            node.setExpanded(shouldBeExpanded);
        }
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        if (!this.filterText.equals(filterText)) {
            this.filterText = filterText;
            this.listeners.broadcast((Event)new FilterChangedEvent(filterText));
        }
    }

    public final ListenerContext listeners() {
        return this.listeners;
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    public void notifyOfNodeUpdate(MasterDetailsContentNode node) {
        this.listeners.broadcast((Event)new NodeUpdatedEvent(node));
        MasterDetailsContentNode parent = node.getParentNode();
        if (parent != null) {
            this.notifyOfNodeUpdate(parent);
        }
    }

    public void notifyOfNodeStructureChange(MasterDetailsContentNode node) {
        this.listeners.broadcast((Event)new NodeStructureChangedEvent(node));
    }

    public void notifyOfNodeExpandedStateChange(MasterDetailsContentNode node) {
        this.listeners.broadcast((Event)new NodeExpandedStateChangedEvent(node));
    }

    public void refresh() {
        this.notifyOfNodeStructureChange(null);
    }

    public void dispose() {
        if (this.root != null) {
            this.root.dispose();
        }
    }

    private void handleNodeStructureChange() {
        ArrayList<MasterDetailsContentNode> newSelection = new ArrayList<MasterDetailsContentNode>();
        for (MasterDetailsContentNode node : this.selection) {
            LinkedList<MasterDetailsContentNode> path = new LinkedList<MasterDetailsContentNode>();
            while (node != this.root) {
                path.addFirst(node);
                node = node.getParentNode();
            }
            node = this.root;
            for (MasterDetailsContentNode n : path) {
                if (!node.getChildNodes().contains(n)) break;
                node = n;
            }
            if (node == this.root) {
                List<MasterDetailsContentNode> topLevelNodes = this.root.getChildNodes();
                node = topLevelNodes.size() > 0 ? topLevelNodes.get(0) : null;
            }
            if (newSelection.contains(node)) continue;
            newSelection.add(node);
        }
        this.setSelectedNodes(newSelection);
    }

    private void loadTreeState() {
        ArrayList<MasterDetailsContentNode> selection = new ArrayList<MasterDetailsContentNode>();
        MasterDetailsEditorPageState editorPageState = this.editorPagePart.getState();
        if (editorPageState != null) {
            ContentOutlineNodeState rootNodeState = editorPageState.getContentOutlineState().getRoot();
            for (MasterDetailsContentNode node : this.root.getChildNodes()) {
                this.loadTreeState(rootNodeState, node, selection);
            }
        }
        if (!selection.isEmpty()) {
            this.setSelectedNodes(selection);
        } else {
            MasterDetailsContentNode node = this.root;
            String defaultInitialNodePath = this.editorPageDef.getInitialSelectionPath().getText();
            if (defaultInitialNodePath != null) {
                String[] stringArray = defaultInitialNodePath.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if ((node = node.getChildNodeByLabel(segment)) == null) break;
                    node.setExpanded(true);
                    ++n2;
                }
            }
            if (node != null) {
                this.setSelectedNode(node);
            }
        }
    }

    private void loadTreeState(ContentOutlineNodeState parentNodeState, MasterDetailsContentNode node, List<MasterDetailsContentNode> selection) {
        String nodeLabel = node.getLabel();
        for (ContentOutlineNodeState childNodeState : parentNodeState.getChildren()) {
            if (!nodeLabel.equals(childNodeState.getLabel().getText())) continue;
            node.setExpanded((Boolean)childNodeState.getExpanded().getContent());
            if (((Boolean)childNodeState.getSelected().getContent()).booleanValue()) {
                selection.add(node);
            }
            for (MasterDetailsContentNode child : node.getChildNodes()) {
                this.loadTreeState(childNodeState, child, selection);
            }
        }
    }

    private void saveTreeState() {
        MasterDetailsEditorPageState editorPageState = this.editorPagePart.getState();
        if (editorPageState != null) {
            ContentOutlineNodeState rootNodeState = editorPageState.getContentOutlineState().getRoot();
            rootNodeState.getChildren().clear();
            List<MasterDetailsContentNode> selection = this.getSelectedNodes();
            for (MasterDetailsContentNode node : this.root.getChildNodes()) {
                this.saveTreeState(rootNodeState, node, selection);
            }
            try {
                rootNodeState.resource().save();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    private void saveTreeState(ContentOutlineNodeState parentNodeState, MasterDetailsContentNode node, List<MasterDetailsContentNode> selection) {
        boolean isExpanded = node.isExpanded();
        boolean isSelected = selection.contains(node);
        if (isExpanded || isSelected) {
            ContentOutlineNodeState childNodeState = (ContentOutlineNodeState)parentNodeState.getChildren().insert();
            childNodeState.setLabel(node.getLabel());
            if (isExpanded) {
                childNodeState.setExpanded(isExpanded);
            }
            if (isSelected) {
                childNodeState.setSelected(isSelected);
            }
            for (MasterDetailsContentNode child : node.getChildNodes()) {
                this.saveTreeState(childNodeState, child, selection);
            }
        }
    }

    public static final class FilterChangedEvent
    extends Event {
        private final String filter;

        public FilterChangedEvent(String filter) {
            this.filter = filter;
        }

        public String filter() {
            return this.filter;
        }
    }

    public static final class NodeExpandedStateChangedEvent
    extends Event {
        private final MasterDetailsContentNode node;

        public NodeExpandedStateChangedEvent(MasterDetailsContentNode node) {
            this.node = node;
        }

        public MasterDetailsContentNode node() {
            return this.node;
        }
    }

    public static final class NodeStructureChangedEvent
    extends Event {
        private final MasterDetailsContentNode node;

        public NodeStructureChangedEvent(MasterDetailsContentNode node) {
            this.node = node;
        }

        public MasterDetailsContentNode node() {
            return this.node;
        }
    }

    public static final class NodeUpdatedEvent
    extends Event {
        private final MasterDetailsContentNode node;

        public NodeUpdatedEvent(MasterDetailsContentNode node) {
            this.node = node;
        }

        public MasterDetailsContentNode node() {
            return this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SelectionChangedEvent
    extends Event {
        private final List<MasterDetailsContentNode> selection;

        public SelectionChangedEvent(List<MasterDetailsContentNode> selection) {
            this.selection = ReadOnlyListFactory.create(selection);
        }

        public List<MasterDetailsContentNode> selection() {
            return this.selection;
        }
    }
}

