/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormColors;

public abstract class SapphirePopup
extends Window {
    private FormColors colors;
    private Shell shell;
    private Region lastUsedRegion;
    private Image lastUsedBgImage;
    private boolean listenToDeactivate;
    private boolean listenToParentDeactivate;
    private Listener parentDeactivateListener;
    private Control contentArea;
    private final Point position;

    public SapphirePopup(Shell shell, Point position) {
        this(shell, position, 540684);
    }

    public SapphirePopup(Shell shell, Point position, int style) {
        super(shell);
        this.setShellStyle(style);
        this.position = position;
        this.colors = new FormColors(shell.getDisplay());
    }

    protected Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(1, 1).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
        newShell.setBackground(this.colors.getBorderColor());
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (SapphirePopup.this.listenToDeactivate && event.widget == SapphirePopup.this.getShell() && SapphirePopup.this.getShell().getShells().length == 0) {
                    SapphirePopup.this.asyncClose();
                } else {
                    SapphirePopup.this.listenToDeactivate = true;
                }
            }
        });
        this.shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == SapphirePopup.this.getShell() && SapphirePopup.this.getShell().getShells().length == 0) {
                    SapphirePopup.this.listenToDeactivate = true;
                    SapphirePopup.this.listenToParentDeactivate = !Util.isMac();
                }
            }
        });
        if ((this.getShellStyle() & 0x4000) != 0 && this.shell.getParent() != null) {
            this.parentDeactivateListener = new Listener(){

                public void handleEvent(Event event) {
                    if (SapphirePopup.this.listenToParentDeactivate) {
                        SapphirePopup.this.asyncClose();
                    } else {
                        SapphirePopup.this.listenToParentDeactivate = SapphirePopup.this.listenToDeactivate;
                    }
                }
            };
            this.shell.getParent().addListener(27, this.parentDeactivateListener);
        }
    }

    private void asyncClose() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SapphirePopup.this.close();
            }
        });
    }

    public void create() {
        super.create();
        this.addRegion(this.shell);
    }

    private void addRegion(Shell shell) {
        Region region = new Region();
        Point s = shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, 0, 5, 1);
        region.subtract(0, 1, 3, 1);
        region.subtract(0, 2, 2, 1);
        region.subtract(0, 3, 1, 1);
        region.subtract(0, 4, 1, 1);
        region.subtract(s.x - 5, 0, 5, 1);
        region.subtract(s.x - 3, 1, 3, 1);
        region.subtract(s.x - 2, 2, 2, 1);
        region.subtract(s.x - 1, 3, 1, 1);
        region.subtract(s.x - 1, 4, 1, 1);
        region.subtract(0, s.y, 5, 1);
        region.subtract(0, s.y - 1, 3, 1);
        region.subtract(0, s.y - 2, 2, 1);
        region.subtract(0, s.y - 3, 1, 1);
        region.subtract(0, s.y - 4, 1, 1);
        region.subtract(s.x - 5, s.y - 0, 5, 1);
        region.subtract(s.x - 3, s.y - 1, 3, 1);
        region.subtract(s.x - 2, s.y - 2, 2, 1);
        region.subtract(s.x - 1, s.y - 3, 1, 1);
        region.subtract(s.x - 1, s.y - 4, 1, 1);
        if (shell.getRegion() != null) {
            shell.getRegion().dispose();
        }
        shell.setRegion(region);
        this.lastUsedRegion = region;
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
            this.shell = this.getShell();
        }
        this.constrainShellSize();
        this.listenToDeactivate = false;
        this.listenToParentDeactivate = false;
        Control initialFocusControl = this.getFocusControl();
        if (initialFocusControl == null) {
            this.shell.setVisible(true);
        } else {
            this.shell.open();
            initialFocusControl.setFocus();
        }
        return 0;
    }

    protected Point getInitialLocation(Point size) {
        if (this.position == null) {
            return this.shell.getLocation();
        }
        return this.position;
    }

    protected Control getFocusControl() {
        return this.contentArea;
    }

    protected Control createContents(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 1;
        ((GridLayout)parent.getLayout()).marginHeight = 1;
        final Composite outerCircle = new Composite(parent, 524288);
        outerCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerCircle.setBackgroundMode(2);
        outerCircle.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clArea = outerCircle.getClientArea();
                SapphirePopup.this.lastUsedBgImage = new Image((Device)outerCircle.getDisplay(), clArea.width, clArea.height);
                GC gc = new GC((Drawable)SapphirePopup.this.lastUsedBgImage);
                this.drawGradient(gc, clArea);
                this.fixRegion(gc, clArea);
                gc.dispose();
                Image oldBGImage = outerCircle.getBackgroundImage();
                outerCircle.setBackgroundImage(SapphirePopup.this.lastUsedBgImage);
                if (oldBGImage != null) {
                    oldBGImage.dispose();
                }
            }

            private void drawGradient(GC gc, Rectangle clArea) {
                gc.setForeground(SapphirePopup.this.colors.getBackground());
                gc.setBackground(SapphirePopup.this.colors.getColor("org.eclipse.ui.forms.TB_BG"));
                gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
            }

            private void fixRegion(GC gc, Rectangle clArea) {
                gc.setForeground(SapphirePopup.this.colors.getBorderColor());
                gc.drawPoint(2, 0);
                gc.drawPoint(3, 0);
                gc.drawPoint(1, 1);
                gc.drawPoint(0, 2);
                gc.drawPoint(0, 3);
                gc.drawPoint(clArea.width - 4, 0);
                gc.drawPoint(clArea.width - 3, 0);
                gc.drawPoint(clArea.width - 2, 1);
                gc.drawPoint(clArea.width - 1, 2);
                gc.drawPoint(clArea.width - 1, 3);
                gc.drawPoint(2, clArea.height - 0);
                gc.drawPoint(3, clArea.height - 0);
                gc.drawPoint(1, clArea.height - 1);
                gc.drawPoint(0, clArea.height - 2);
                gc.drawPoint(0, clArea.height - 3);
                gc.drawPoint(clArea.width - 4, clArea.height - 0);
                gc.drawPoint(clArea.width - 3, clArea.height - 0);
                gc.drawPoint(clArea.width - 2, clArea.height - 1);
                gc.drawPoint(clArea.width - 1, clArea.height - 2);
                gc.drawPoint(clArea.width - 1, clArea.height - 3);
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        outerCircle.setLayout((Layout)layout);
        Composite outerContentCircle = new Composite(outerCircle, 0);
        outerContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outerContentCircle.setLayout((Layout)layout);
        outerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerContentCircle.setBackground(outerCircle.getBackground());
        Composite middleContentCircle = new Composite(outerContentCircle, 524288);
        middleContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 1;
        middleContentCircle.setLayout((Layout)layout);
        middleContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        middleContentCircle.setBackground(this.colors.getBorderColor());
        Composite innerContent = new Composite(middleContentCircle, 524288);
        innerContent.setLayoutData((Object)new GridData(4, 4, true, true));
        innerContent.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        innerContent.setLayout((Layout)layout);
        innerContent.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.contentArea = this.createContentArea(innerContent);
        this.setNullBackground(outerCircle);
        return outerCircle;
    }

    private void setNullBackground(Composite outerCircle) {
        Control[] controlArray = outerCircle.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(null);
            if (c instanceof Composite) {
                this.setNullBackground((Composite)c);
            }
            ++n2;
        }
    }

    public boolean close() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return true;
        }
        if (this.lastUsedRegion != null) {
            this.lastUsedRegion.dispose();
        }
        if (this.lastUsedBgImage != null && !this.lastUsedBgImage.isDisposed()) {
            this.lastUsedBgImage.dispose();
        }
        if (this.parentDeactivateListener != null) {
            this.getShell().getParent().removeListener(27, this.parentDeactivateListener);
            this.parentDeactivateListener = null;
        }
        return super.close();
    }
}

