/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.internal;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.util.ReadOnlyListFactory;
import org.eclipse.sapphire.workspace.WorkspaceRelativePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkspaceRelativePathService
extends RelativePathService {
    public List<Path> roots() {
        ReadOnlyListFactory paths = ReadOnlyListFactory.create();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                paths.add((Object)new Path(project.getLocation().toPortableString()));
            }
            ++n2;
        }
        return paths.export();
    }

    public Path convertToRelative(Path path) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path location;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (location = new Path(project.getLocation().toPortableString())).isPrefixOf(path)) {
                return new Path(project.getName()).append(path.makeRelativeTo(location));
            }
            ++n2;
        }
        return null;
    }

    public Path convertToAbsolute(Path path) {
        if (path.segmentCount() > 0) {
            String projectName = path.segment(0);
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && projectName.equals(project.getName())) {
                    return new Path(project.getLocation().toPortableString()).append(path.removeFirstSegments(1));
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            return property != null && Path.class.isAssignableFrom(property.getTypeClass()) && property.hasAnnotation(WorkspaceRelativePath.class);
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new WorkspaceRelativePathService();
        }
    }
}

