/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentityCache<K, V> {
    private Map<K, V> map = new IdentityHashMap();
    private Map<K, V> next = null;

    public V get(K key) {
        V value = this.map.get(key);
        if (this.next != null && value != null) {
            this.next.put(key, value);
        }
        return value;
    }

    public void put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (this.next != null) {
            this.next.put(key, value);
        }
        this.map.put(key, value);
    }

    public void track() {
        this.next = new IdentityHashMap();
    }

    public void purge() {
        this.map = this.next;
        this.next = null;
    }
}

