/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.el.ConcatFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.FormPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.HtmlContentSourceType;
import org.eclipse.sapphire.ui.def.HtmlPanelDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;

public final class HtmlPanelPart
extends FormPart {
    private static final String FRAGMENT_STYLE = MiscUtil.readTextResource(HtmlPanelPart.class, (String)"FragmentStyle.css");
    private static final String FRAGMENT_HEADER = "<html><head><style>" + FRAGMENT_STYLE + "</style></head><body>";
    private static final String FRAGMENT_FOOTER = "</body></html>";
    private HtmlPanelDef def;
    private FunctionResult contentFunctionResult;
    private FunctionResult urlFunctionResult;

    protected void init() {
        super.init();
        IModelElement element = this.getModelElement();
        this.def = (HtmlPanelDef)this.definition;
        if (this.def.getContentSourceType().getContent() == HtmlContentSourceType.EMBEDDED) {
            Function contentFunction = (Function)this.def.getContent().getContent();
            if (((Boolean)this.def.getFragment().getContent()).booleanValue()) {
                contentFunction = ConcatFunction.create((String)FRAGMENT_HEADER, (Function)contentFunction);
                contentFunction = ConcatFunction.create((Function)contentFunction, (String)FRAGMENT_FOOTER);
            }
            this.contentFunctionResult = this.initExpression(element, contentFunction, String.class, null, new Runnable(){

                public void run() {
                    HtmlPanelPart.this.broadcast(new ContentChangedEvent(HtmlPanelPart.this));
                }
            });
        } else {
            this.urlFunctionResult = this.initExpression(element, (Function)this.def.getContentUrl().getContent(), String.class, null, new Runnable(){

                public void run() {
                    HtmlPanelPart.this.broadcast(new ContentChangedEvent(HtmlPanelPart.this));
                }
            });
        }
    }

    public String getContent() {
        if (this.contentFunctionResult == null) {
            return null;
        }
        return (String)this.contentFunctionResult.value();
    }

    public String getContentUrl() {
        if (this.urlFunctionResult == null) {
            return null;
        }
        return (String)this.urlFunctionResult.value();
    }

    public boolean getShowBorder() {
        return (Boolean)this.def.getShowBorder().getContent();
    }

    public void dispose() {
        super.dispose();
        if (this.contentFunctionResult != null) {
            this.contentFunctionResult.dispose();
        }
        if (this.urlFunctionResult != null) {
            this.urlFunctionResult.dispose();
        }
    }

    public void render(SapphireRenderingContext context) {
        boolean scaleVertically = this.getScaleVertically();
        GridData gd = GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhspan(scaleVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2), 100), 9);
        if (!scaleVertically) {
            gd = GridLayoutUtil.gdhhint(gd, (Integer)this.def.getHeight().getContent());
        }
        int style = this.getShowBorder() ? 2048 : 0;
        try {
            Listener listener;
            final Browser browser = new Browser(context.getComposite(), style);
            browser.setLayoutData((Object)gd);
            if (this.def.getContentSourceType().getContent() == HtmlContentSourceType.EMBEDDED) {
                browser.setText(this.getContent());
                listener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof ContentChangedEvent) {
                            browser.setText(HtmlPanelPart.this.getContent());
                        }
                    }
                };
            } else {
                browser.setUrl(this.getContentUrl());
                listener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof ContentChangedEvent) {
                            browser.setUrl(HtmlPanelPart.this.getContentUrl());
                        }
                    }
                };
            }
            this.attach(listener);
            browser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    HtmlPanelPart.this.detach(listener);
                }
            });
        }
        catch (SWTError sWTError) {
            SapphireFormText text = new SapphireFormText(context.getComposite(), style);
            text.setText(Resources.couldNotInitializeBrowserMessage, false, false);
            text.setLayoutData(gd);
        }
    }

    public static final class ContentChangedEvent
    extends SapphirePart.PartEvent {
        public ContentChangedEvent(SapphirePart part) {
            super(part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String couldNotInitializeBrowserMessage;

        static {
            Resources.initializeMessages((String)HtmlPanelPart.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

