/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0005.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;
import org.eclipse.sapphire.tests.modeling.events.t0005.ChildElement;
import org.eclipse.sapphire.tests.modeling.events.t0005.RootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RootElementImpl
extends ModelElement
implements RootElement {
    private ModelElementHandle<ChildElement> pElement;
    private Value<Boolean> pEnabled;
    private ModelElementHandle<ChildElement> pImpliedElement;
    private ModelElementList<ChildElement> pList;
    private Value<String> pValue;

    public RootElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public RootElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<ChildElement> getElement() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pElement == null) {
                this.refresh((ModelProperty)PROP_ELEMENT, true);
            }
            return this.pElement;
        }
    }

    protected void disposeProperties() {
        IModelElement element2;
        if (this.pElement != null && (element2 = this.pElement.element(false)) != null) {
            element2.dispose();
        }
        if (this.pImpliedElement != null && (element2 = this.pImpliedElement.element(false)) != null) {
            element2.dispose();
        }
        if (this.pList != null) {
            for (IModelElement element2 : this.pList) {
                element2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Boolean> getEnabled() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pEnabled == null) {
                this.refresh((ModelProperty)PROP_ENABLED, true);
            }
            return this.pEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ENABLED.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ENABLED, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ENABLED, true);
            if (!RootElementImpl.equal((String)this.pEnabled.getText(false), (String)value)) {
                this.resource().binding(PROP_ENABLED).write(value);
                this.refresh((ModelProperty)PROP_ENABLED, false);
            }
        }
    }

    @Override
    public void setEnabled(Boolean value) {
        this.setEnabled(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_ENABLED, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildElement getImpliedElement() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pImpliedElement == null) {
                this.refresh((ModelProperty)PROP_IMPLIED_ELEMENT, true);
            }
            return (ChildElement)this.pImpliedElement.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ChildElement> getList() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pList == null) {
                this.refresh((ModelProperty)PROP_LIST, true);
            }
            return this.pList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pValue == null) {
                this.refresh((ModelProperty)PROP_VALUE, true);
            }
            return this.pValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_VALUE, true);
            if (!RootElementImpl.equal((String)this.pValue.getText(false), (String)value)) {
                this.resource().binding(PROP_VALUE).write(value);
                this.refresh((ModelProperty)PROP_VALUE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ELEMENT) {
                if (this.pElement == null) {
                    if (force) {
                        this.pElement = new ModelElementHandle((IModelElement)this, PROP_ELEMENT);
                        this.pElement.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_ELEMENT);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ELEMENT));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ELEMENT);
                    boolean notified = this.pElement.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ELEMENT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_ENABLED) {
                if (this.pEnabled != null || force) {
                    Value<Boolean> oldValue = this.pEnabled;
                    String val = this.resource().binding(PROP_ENABLED).read();
                    this.pEnabled = new Value((IModelElement)this, PROP_ENABLED, ((ValueNormalizationService)this.service((ModelProperty)PROP_ENABLED, ValueNormalizationService.class)).normalize(PROP_ENABLED.encodeKeywords(val)));
                    this.pEnabled.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ENABLED);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ENABLED));
                    } else {
                        if (this.pEnabled.equals(oldValue)) {
                            this.pEnabled = oldValue;
                        } else {
                            if (!RootElementImpl.equal((String)this.pEnabled.getText(false), (String)oldValue.getText(false)) || !RootElementImpl.equal((String)this.pEnabled.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_ENABLED));
                            }
                            if (!this.pEnabled.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_ENABLED, oldValue.validation(), this.pEnabled.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ENABLED, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_IMPLIED_ELEMENT) {
                if (this.pImpliedElement == null) {
                    if (force) {
                        this.pImpliedElement = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_IMPLIED_ELEMENT);
                        this.pImpliedElement.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_IMPLIED_ELEMENT);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_IMPLIED_ELEMENT));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_IMPLIED_ELEMENT);
                    boolean notified = this.pImpliedElement.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_IMPLIED_ELEMENT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_LIST) {
                if (this.pList == null) {
                    if (force) {
                        this.pList = new ModelElementList((IModelElement)this, PROP_LIST);
                        ListBindingImpl binding = this.resource().binding(PROP_LIST);
                        this.pList.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_LIST);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_LIST));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_LIST);
                    boolean notified = this.pList.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_LIST, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_VALUE && (this.pValue != null || force)) {
                Value<String> oldValue = this.pValue;
                String val = this.resource().binding(PROP_VALUE).read();
                this.pValue = new Value((IModelElement)this, PROP_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_VALUE, ValueNormalizationService.class)).normalize(PROP_VALUE.encodeKeywords(val)));
                this.pValue.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_VALUE);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_VALUE));
                } else {
                    if (this.pValue.equals(oldValue)) {
                        this.pValue = oldValue;
                    } else {
                        if (!RootElementImpl.equal((String)this.pValue.getText(false), (String)oldValue.getText(false)) || !RootElementImpl.equal((String)this.pValue.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_VALUE));
                        }
                        if (!this.pValue.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_VALUE, oldValue.validation(), this.pValue.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_VALUE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ELEMENT) {
            return this.getElement();
        }
        if (property == PROP_ENABLED) {
            return this.getEnabled();
        }
        if (property == PROP_IMPLIED_ELEMENT) {
            return this.getImpliedElement();
        }
        if (property == PROP_LIST) {
            return this.getList();
        }
        if (property == PROP_VALUE) {
            return this.getValue();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_ENABLED) {
            if (!(value instanceof String)) {
                this.setEnabled((Boolean)value);
            } else {
                this.setEnabled((String)value);
            }
            return;
        }
        if (property == PROP_VALUE) {
            this.setValue((String)value);
            return;
        }
        super.write(property, value);
    }
}

