/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.architecture.IComponent;
import org.eclipse.sapphire.samples.architecture.IComponentDependency;
import org.eclipse.sapphire.samples.architecture.Position;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Component
extends ModelElement
implements IComponent {
    private Value<String> pCopyright;
    private ModelElementList<IComponentDependency> pDependencies;
    private Value<String> pDescription;
    private Value<String> pName;
    private ModelElementHandle<Position> pPosition;
    private Value<String> pProvider;

    public Component(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Component(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCopyright() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pCopyright == null) {
                this.refresh((ModelProperty)PROP_COPYRIGHT, true);
            }
            return this.pCopyright;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCopyright(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_COPYRIGHT.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_COPYRIGHT, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_COPYRIGHT, true);
            if (!Component.equal((String)this.pCopyright.getText(false), (String)value)) {
                this.resource().binding(PROP_COPYRIGHT).write(value);
                this.refresh((ModelProperty)PROP_COPYRIGHT, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IComponentDependency> getDependencies() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pDependencies == null) {
                this.refresh((ModelProperty)PROP_DEPENDENCIES, true);
            }
            return this.pDependencies;
        }
    }

    protected void disposeProperties() {
        IModelElement element2;
        if (this.pDependencies != null) {
            for (IModelElement element2 : this.pDependencies) {
                element2.dispose();
            }
        }
        if (this.pPosition != null && (element2 = this.pPosition.element(false)) != null) {
            element2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pDescription == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.pDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!Component.equal((String)this.pDescription.getText(false), (String)value)) {
                this.resource().binding(PROP_DESCRIPTION).write(value);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pName == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.pName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!Component.equal((String)this.pName.getText(false), (String)value)) {
                this.resource().binding(PROP_NAME).write(value);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Position getPosition() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pPosition == null) {
                this.refresh((ModelProperty)PROP_POSITION, true);
            }
            return (Position)this.pPosition.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getProvider() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pProvider == null) {
                this.refresh((ModelProperty)PROP_PROVIDER, true);
            }
            return this.pProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvider(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PROVIDER.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_PROVIDER, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_PROVIDER, true);
            if (!Component.equal((String)this.pProvider.getText(false), (String)value)) {
                this.resource().binding(PROP_PROVIDER).write(value);
                this.refresh((ModelProperty)PROP_PROVIDER, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_COPYRIGHT) {
                if (this.pCopyright != null || force) {
                    Value<String> oldValue = this.pCopyright;
                    String val = this.resource().binding(PROP_COPYRIGHT).read();
                    this.pCopyright = new Value((IModelElement)this, PROP_COPYRIGHT, ((ValueNormalizationService)this.service((ModelProperty)PROP_COPYRIGHT, ValueNormalizationService.class)).normalize(PROP_COPYRIGHT.encodeKeywords(val)));
                    this.pCopyright.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_COPYRIGHT);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT));
                    } else {
                        if (this.pCopyright.equals(oldValue)) {
                            this.pCopyright = oldValue;
                        } else {
                            if (!Component.equal((String)this.pCopyright.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.pCopyright.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT));
                            }
                            if (!this.pCopyright.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT, oldValue.validation(), this.pCopyright.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_COPYRIGHT, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_DEPENDENCIES) {
                if (this.pDependencies == null) {
                    if (force) {
                        this.pDependencies = new ModelElementList((IModelElement)this, PROP_DEPENDENCIES);
                        ListBindingImpl binding = this.resource().binding(PROP_DEPENDENCIES);
                        this.pDependencies.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_DEPENDENCIES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_DEPENDENCIES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DEPENDENCIES);
                    boolean notified = this.pDependencies.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_DEPENDENCIES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_DESCRIPTION) {
                if (this.pDescription != null || force) {
                    Value<String> oldValue = this.pDescription;
                    String val = this.resource().binding(PROP_DESCRIPTION).read();
                    this.pDescription = new Value((IModelElement)this, PROP_DESCRIPTION, ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(PROP_DESCRIPTION.encodeKeywords(val)));
                    this.pDescription.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DESCRIPTION);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION));
                    } else {
                        if (this.pDescription.equals(oldValue)) {
                            this.pDescription = oldValue;
                        } else {
                            if (!Component.equal((String)this.pDescription.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.pDescription.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION));
                            }
                            if (!this.pDescription.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION, oldValue.validation(), this.pDescription.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_DESCRIPTION, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_NAME) {
                if (this.pName != null || force) {
                    Value<String> oldValue = this.pName;
                    String val = this.resource().binding(PROP_NAME).read();
                    this.pName = new Value((IModelElement)this, PROP_NAME, ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(PROP_NAME.encodeKeywords(val)));
                    this.pName.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_NAME);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_NAME));
                    } else {
                        if (this.pName.equals(oldValue)) {
                            this.pName = oldValue;
                        } else {
                            if (!Component.equal((String)this.pName.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.pName.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_NAME));
                            }
                            if (!this.pName.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_NAME, oldValue.validation(), this.pName.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_NAME, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_POSITION) {
                if (this.pPosition == null) {
                    if (force) {
                        this.pPosition = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_POSITION);
                        this.pPosition.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_POSITION);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_POSITION));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_POSITION);
                    boolean notified = this.pPosition.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_POSITION, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_PROVIDER && (this.pProvider != null || force)) {
                Value<String> oldValue = this.pProvider;
                String val = this.resource().binding(PROP_PROVIDER).read();
                this.pProvider = new Value((IModelElement)this, PROP_PROVIDER, ((ValueNormalizationService)this.service((ModelProperty)PROP_PROVIDER, ValueNormalizationService.class)).normalize(PROP_PROVIDER.encodeKeywords(val)));
                this.pProvider.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_PROVIDER);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER));
                } else {
                    if (this.pProvider.equals(oldValue)) {
                        this.pProvider = oldValue;
                    } else {
                        if (!Component.equal((String)this.pProvider.getText(false), (String)oldValue.getText(false)) || !Component.equal((String)this.pProvider.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER));
                        }
                        if (!this.pProvider.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER, oldValue.validation(), this.pProvider.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_PROVIDER, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_COPYRIGHT) {
            return this.getCopyright();
        }
        if (property == PROP_DEPENDENCIES) {
            return this.getDependencies();
        }
        if (property == PROP_DESCRIPTION) {
            return this.getDescription();
        }
        if (property == PROP_NAME) {
            return this.getName();
        }
        if (property == PROP_POSITION) {
            return this.getPosition();
        }
        if (property == PROP_PROVIDER) {
            return this.getProvider();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_COPYRIGHT) {
            this.setCopyright((String)value);
            return;
        }
        if (property == PROP_DESCRIPTION) {
            this.setDescription((String)value);
            return;
        }
        if (property == PROP_NAME) {
            this.setName((String)value);
            return;
        }
        if (property == PROP_PROVIDER) {
            this.setProvider((String)value);
            return;
        }
        super.write(property, value);
    }
}

