/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.map.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.samples.map.Location;
import org.eclipse.sapphire.samples.map.Map;
import org.eclipse.sapphire.samples.map.Route;
import org.eclipse.sapphire.samples.map.internal.MapMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapImpl
extends ModelElement
implements Map {
    private ModelElementList<Location> pLocations;
    private ModelElementList<Route> pRoutes;

    public MapImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public MapImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<Location> getLocations() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pLocations == null) {
                this.refresh((ModelProperty)PROP_LOCATIONS, true);
            }
            return this.pLocations;
        }
    }

    protected void disposeProperties() {
        if (this.pLocations != null) {
            for (IModelElement element : this.pLocations) {
                element.dispose();
            }
        }
        if (this.pRoutes != null) {
            for (IModelElement element : this.pRoutes) {
                element.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<Route> getRoutes() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pRoutes == null) {
                this.refresh((ModelProperty)PROP_ROUTES, true);
            }
            return this.pRoutes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location findLocation(String name) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return MapMethods.findLocation(this, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLocation(String name) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return MapMethods.hasLocation(this, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_LOCATIONS) {
                if (this.pLocations == null) {
                    if (force) {
                        this.pLocations = new ModelElementList((IModelElement)this, PROP_LOCATIONS);
                        ListBindingImpl binding = this.resource().binding(PROP_LOCATIONS);
                        this.pLocations.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_LOCATIONS);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_LOCATIONS));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_LOCATIONS);
                    boolean notified = this.pLocations.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_LOCATIONS, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_ROUTES) {
                if (this.pRoutes == null) {
                    if (force) {
                        this.pRoutes = new ModelElementList((IModelElement)this, PROP_ROUTES);
                        ListBindingImpl binding = this.resource().binding(PROP_ROUTES);
                        this.pRoutes.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_ROUTES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ROUTES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ROUTES);
                    boolean notified = this.pRoutes.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ROUTES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_LOCATIONS) {
            return this.getLocations();
        }
        if (property == PROP_ROUTES) {
            return this.getRoutes();
        }
        return super.read(property);
    }
}

