/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;

public abstract class PropertyEvent
extends Event {
    private final IModelElement element;
    private final ModelProperty property;

    protected PropertyEvent(IModelElement element, ModelProperty property) {
        this.element = element;
        this.property = property;
    }

    public final IModelElement element() {
        return this.element;
    }

    public final ModelProperty property() {
        return this.property;
    }

    public static final Listener filter(Listener listener) {
        return Event.filter(listener, PropertyEvent.class);
    }

    public static final Listener filter(Listener listener, ModelProperty property) {
        return new FilteredListener(listener, property);
    }

    private static final class FilteredListener
    extends Listener {
        private final Listener listener;
        private final ModelProperty property;

        public FilteredListener(Listener listener, ModelProperty property) {
            this.listener = listener;
            this.property = property;
        }

        public void handle(Event event) {
            if (event instanceof PropertyEvent && ((PropertyEvent)event).property() == this.property) {
                this.listener.handle(event);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilteredListener) {
                FilteredListener x = (FilteredListener)obj;
                return this.listener.equals(x.listener) && this.property == x.property;
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.property.hashCode();
        }
    }
}

