/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueBindingImpl;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactsDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttendeeResource
extends Resource {
    private final org.eclipse.sapphire.samples.calendar.IAttendee base;
    private final ContactsDatabase contacts;
    private final Listener listener;

    public AttendeeResource(Resource parent, org.eclipse.sapphire.samples.calendar.IAttendee base) {
        super(parent);
        this.base = base;
        this.contacts = this.adapt(ContactsDatabase.class);
        this.listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                if (!(event instanceof PropertyInitializationEvent)) {
                    ModelProperty property = event.property();
                    IModelElement element = AttendeeResource.this.element();
                    if (property == org.eclipse.sapphire.samples.calendar.IAttendee.PROP_NAME) {
                        element.refresh((ModelProperty)IAttendee.PROP_NAME);
                        element.refresh((ModelProperty)IAttendee.PROP_IN_CONTACTS_DATABASE);
                        element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                    } else if (property == org.eclipse.sapphire.samples.calendar.IAttendee.PROP_TYPE) {
                        element.refresh((ModelProperty)IAttendee.PROP_TYPE);
                    } else if (property == ContactsDatabase.PROP_CONTACTS) {
                        element.refresh((ModelProperty)IAttendee.PROP_IN_CONTACTS_DATABASE);
                        element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                    } else if (property == Contact.PROP_NAME) {
                        element.refresh((ModelProperty)IAttendee.PROP_IN_CONTACTS_DATABASE);
                        element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                    } else if (property == Contact.PROP_E_MAIL) {
                        element.refresh((ModelProperty)IAttendee.PROP_E_MAIL);
                    }
                }
            }
        };
        this.base.attach(this.listener);
        this.contacts.attach(this.listener);
    }

    public org.eclipse.sapphire.samples.calendar.IAttendee getBase() {
        return this.base;
    }

    protected BindingImpl createBinding(ModelProperty property) {
        if (property == IAttendee.PROP_NAME) {
            return new ValueBindingImpl(){

                public String read() {
                    return AttendeeResource.this.getBase().getName().getText(false);
                }

                public void write(String value) {
                    AttendeeResource.this.getBase().setName(value);
                }
            };
        }
        if (property == IAttendee.PROP_TYPE) {
            return new ValueBindingImpl(){

                public String read() {
                    return AttendeeResource.this.getBase().getType().getText(false);
                }

                public void write(String value) {
                    AttendeeResource.this.getBase().setType(value);
                }
            };
        }
        if (property == IAttendee.PROP_E_MAIL) {
            return new ValueBindingImpl(){

                public String read() {
                    Contact c = AttendeeResource.this.findContactRecord(false);
                    return c != null ? c.getEMail().getText() : null;
                }

                public void write(String value) {
                    Contact c = AttendeeResource.this.findContactRecord(value != null);
                    if (c != null) {
                        c.setEMail(value);
                    }
                }
            };
        }
        if (property == IAttendee.PROP_IN_CONTACTS_DATABASE) {
            return new ValueBindingImpl(){

                public String read() {
                    return AttendeeResource.this.findContactRecord(false) != null ? Boolean.TRUE.toString() : null;
                }

                public void write(String value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    private Contact findContactRecord(boolean createIfNecessary) {
        Contact c = null;
        String name = this.base.getName().getText();
        if (name != null) {
            for (Contact contact : this.contacts.getContacts()) {
                if (!name.equals(contact.getName().getText())) continue;
                c = contact;
                break;
            }
            if (c == null && createIfNecessary) {
                c = (Contact)this.contacts.getContacts().insert();
                c.setName(name);
            }
            for (Contact contact : this.contacts.getContacts()) {
                contact.attach(this.listener);
            }
        }
        return c;
    }

    public <A> A adapt(Class<A> adapterType) {
        Object res = super.adapt(adapterType);
        if (res == null) {
            res = this.base.adapt(adapterType);
        }
        return (A)res;
    }

    public void dispose() {
        super.dispose();
        this.base.detach(this.listener);
        this.contacts.detach(this.listener);
    }
}

