/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.ElementPropertyCustomGallery;
import org.eclipse.sapphire.samples.gallery.IChildElement;
import org.eclipse.sapphire.samples.gallery.IChildElementWithInteger;
import org.eclipse.sapphire.samples.gallery.IElementPropertiesGallery;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementPropertiesGallery
extends ModelElement
implements IElementPropertiesGallery {
    private ModelElementHandle<ElementPropertyCustomGallery> pCustomPossibleTypes;
    private ModelElementHandle<IChildElement> pHeterogeneous;
    private ModelElementHandle<IChildElement> pHomogeneous;
    private ModelElementHandle<IChildElementWithInteger> pImplied;
    private Value<Integer> pIntegerValue;
    private Value<String> pStringValue;

    public ElementPropertiesGallery(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ElementPropertiesGallery(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementPropertyCustomGallery getCustomPossibleTypes() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pCustomPossibleTypes == null) {
                this.refresh((ModelProperty)PROP_CUSTOM_POSSIBLE_TYPES, true);
            }
            return (ElementPropertyCustomGallery)this.pCustomPossibleTypes.element();
        }
    }

    protected void disposeProperties() {
        IModelElement element;
        if (this.pCustomPossibleTypes != null && (element = this.pCustomPossibleTypes.element(false)) != null) {
            element.dispose();
        }
        if (this.pHeterogeneous != null && (element = this.pHeterogeneous.element(false)) != null) {
            element.dispose();
        }
        if (this.pHomogeneous != null && (element = this.pHomogeneous.element(false)) != null) {
            element.dispose();
        }
        if (this.pImplied != null && (element = this.pImplied.element(false)) != null) {
            element.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<IChildElement> getHeterogeneous() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pHeterogeneous == null) {
                this.refresh((ModelProperty)PROP_HETEROGENEOUS, true);
            }
            return this.pHeterogeneous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<IChildElement> getHomogeneous() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pHomogeneous == null) {
                this.refresh((ModelProperty)PROP_HOMOGENEOUS, true);
            }
            return this.pHomogeneous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChildElementWithInteger getImplied() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pImplied == null) {
                this.refresh((ModelProperty)PROP_IMPLIED, true);
            }
            return (IChildElementWithInteger)this.pImplied.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getIntegerValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pIntegerValue == null) {
                this.refresh((ModelProperty)PROP_INTEGER_VALUE, true);
            }
            return this.pIntegerValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIntegerValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_INTEGER_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_INTEGER_VALUE, true);
            if (!ElementPropertiesGallery.equal((String)this.pIntegerValue.getText(false), (String)value)) {
                this.resource().binding(PROP_INTEGER_VALUE).write(value);
                this.refresh((ModelProperty)PROP_INTEGER_VALUE, false);
            }
        }
    }

    @Override
    public void setIntegerValue(Integer value) {
        this.setIntegerValue(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_INTEGER_VALUE, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStringValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pStringValue == null) {
                this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            }
            return this.pStringValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            if (!ElementPropertiesGallery.equal((String)this.pStringValue.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING_VALUE).write(value);
                this.refresh((ModelProperty)PROP_STRING_VALUE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CUSTOM_POSSIBLE_TYPES) {
                if (this.pCustomPossibleTypes == null) {
                    if (force) {
                        this.pCustomPossibleTypes = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_CUSTOM_POSSIBLE_TYPES);
                        this.pCustomPossibleTypes.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_CUSTOM_POSSIBLE_TYPES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CUSTOM_POSSIBLE_TYPES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CUSTOM_POSSIBLE_TYPES);
                    boolean notified = this.pCustomPossibleTypes.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CUSTOM_POSSIBLE_TYPES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_HETEROGENEOUS) {
                if (this.pHeterogeneous == null) {
                    if (force) {
                        this.pHeterogeneous = new ModelElementHandle((IModelElement)this, PROP_HETEROGENEOUS);
                        this.pHeterogeneous.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_HETEROGENEOUS);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_HETEROGENEOUS));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_HETEROGENEOUS);
                    boolean notified = this.pHeterogeneous.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_HETEROGENEOUS, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_HOMOGENEOUS) {
                if (this.pHomogeneous == null) {
                    if (force) {
                        this.pHomogeneous = new ModelElementHandle((IModelElement)this, PROP_HOMOGENEOUS);
                        this.pHomogeneous.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_HOMOGENEOUS);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_HOMOGENEOUS));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_HOMOGENEOUS);
                    boolean notified = this.pHomogeneous.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_HOMOGENEOUS, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_IMPLIED) {
                if (this.pImplied == null) {
                    if (force) {
                        this.pImplied = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_IMPLIED);
                        this.pImplied.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_IMPLIED);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_IMPLIED));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_IMPLIED);
                    boolean notified = this.pImplied.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_IMPLIED, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_INTEGER_VALUE) {
                if (this.pIntegerValue != null || force) {
                    Value<Integer> oldValue = this.pIntegerValue;
                    String val = this.resource().binding(PROP_INTEGER_VALUE).read();
                    this.pIntegerValue = new Value((IModelElement)this, PROP_INTEGER_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER_VALUE, ValueNormalizationService.class)).normalize(PROP_INTEGER_VALUE.encodeKeywords(val)));
                    this.pIntegerValue.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_INTEGER_VALUE);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_VALUE));
                    } else {
                        if (this.pIntegerValue.equals(oldValue)) {
                            this.pIntegerValue = oldValue;
                        } else {
                            if (!ElementPropertiesGallery.equal((String)this.pIntegerValue.getText(false), (String)oldValue.getText(false)) || !ElementPropertiesGallery.equal((String)this.pIntegerValue.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_VALUE));
                            }
                            if (!this.pIntegerValue.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_VALUE, oldValue.validation(), this.pIntegerValue.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_VALUE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_STRING_VALUE && (this.pStringValue != null || force)) {
                Value<String> oldValue = this.pStringValue;
                String val = this.resource().binding(PROP_STRING_VALUE).read();
                this.pStringValue = new Value((IModelElement)this, PROP_STRING_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(PROP_STRING_VALUE.encodeKeywords(val)));
                this.pStringValue.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STRING_VALUE);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE));
                } else {
                    if (this.pStringValue.equals(oldValue)) {
                        this.pStringValue = oldValue;
                    } else {
                        if (!ElementPropertiesGallery.equal((String)this.pStringValue.getText(false), (String)oldValue.getText(false)) || !ElementPropertiesGallery.equal((String)this.pStringValue.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE));
                        }
                        if (!this.pStringValue.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE, oldValue.validation(), this.pStringValue.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_STRING_VALUE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CUSTOM_POSSIBLE_TYPES) {
            return this.getCustomPossibleTypes();
        }
        if (property == PROP_HETEROGENEOUS) {
            return this.getHeterogeneous();
        }
        if (property == PROP_HOMOGENEOUS) {
            return this.getHomogeneous();
        }
        if (property == PROP_IMPLIED) {
            return this.getImplied();
        }
        if (property == PROP_INTEGER_VALUE) {
            return this.getIntegerValue();
        }
        if (property == PROP_STRING_VALUE) {
            return this.getStringValue();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_INTEGER_VALUE) {
            if (!(value instanceof String)) {
                this.setIntegerValue((Integer)value);
            } else {
                this.setIntegerValue((String)value);
            }
            return;
        }
        if (property == PROP_STRING_VALUE) {
            this.setStringValue((String)value);
            return;
        }
        super.write(property, value);
    }
}

