/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class DiagramDeleteActionHandler
extends SapphireActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        ISapphirePart part = this.getPart();
        if (part instanceof SapphireDiagramEditorPagePart) {
            ((SapphireDiagramEditorPagePart)part).attach((Listener)new FilteredListener<SapphireEditorPagePart.SelectionChangedEvent>(){

                protected void handleTypedEvent(SapphireEditorPagePart.SelectionChangedEvent event) {
                    DiagramDeleteActionHandler.this.refreshEnablement();
                }
            });
        }
        this.refreshEnablement();
    }

    private void refreshEnablement() {
        ISapphirePart part = this.getPart();
        boolean enabled = false;
        if (part instanceof DiagramNodePart || part instanceof DiagramConnectionPart && !(part instanceof DiagramImplicitConnectionPart)) {
            enabled = true;
        } else {
            SapphireDiagramEditorPagePart diagramPart = part.nearest(SapphireDiagramEditorPagePart.class);
            List<ISapphirePart> selectedParts = diagramPart.getSelections();
            for (ISapphirePart selectedPart : selectedParts) {
                if (!(selectedPart instanceof DiagramNodePart) && (!(selectedPart instanceof DiagramConnectionPart) || part instanceof DiagramImplicitConnectionPart)) continue;
                enabled = true;
            }
        }
        this.setEnabled(enabled);
    }

    protected Object run(SapphireRenderingContext context) {
        ISapphirePart part = context.getPart();
        if (part instanceof DiagramConnectionPart) {
            DiagramConnectionPart connPart = (DiagramConnectionPart)part;
            this.deleteConnection(connPart);
        } else if (part instanceof DiagramNodePart) {
            DiagramNodePart nodePart = (DiagramNodePart)part;
            this.deleteNode(nodePart);
        } else if (part instanceof SapphireDiagramEditorPagePart) {
            SapphireDiagramEditorPagePart pagePart = (SapphireDiagramEditorPagePart)part;
            ArrayList<ISapphirePart> parts = new ArrayList<ISapphirePart>();
            parts.addAll(pagePart.getSelections());
            for (ISapphirePart selectedPart : parts) {
                if (selectedPart instanceof DiagramConnectionPart) {
                    DiagramConnectionPart connPart = (DiagramConnectionPart)selectedPart;
                    this.deleteConnection(connPart);
                    continue;
                }
                if (!(selectedPart instanceof DiagramNodePart)) continue;
                DiagramNodePart nodePart = (DiagramNodePart)selectedPart;
                this.deleteNode(nodePart);
            }
        }
        return null;
    }

    private void deleteNodeConnections(DiagramNodePart nodePart) {
        IModelElement nodeModel = nodePart.getLocalModelElement();
        SapphireDiagramEditorPagePart diagramPart = nodePart.getDiagramNodeTemplate().getDiagramEditorPart();
        for (DiagramNodeTemplate nodeTemplate : diagramPart.getNodeTemplates()) {
            DiagramEmbeddedConnectionTemplate embeddedConn = nodeTemplate.getEmbeddedConnectionTemplate();
            if (embeddedConn == null) continue;
            for (DiagramConnectionPart connPart : embeddedConn.getDiagramConnections(null)) {
                if ((connPart.getEndpoint1() == null || !connPart.getEndpoint1().equals(nodeModel)) && (connPart.getEndpoint2() == null || !connPart.getEndpoint2().equals(nodeModel))) continue;
                this.deleteConnection(connPart);
            }
        }
        for (DiagramConnectionTemplate connTemplate : diagramPart.getConnectionTemplates()) {
            for (DiagramConnectionPart connPart : connTemplate.getDiagramConnections(null)) {
                if ((connPart.getEndpoint1() == null || !connPart.getEndpoint1().equals(nodeModel)) && (connPart.getEndpoint2() == null || !connPart.getEndpoint2().equals(nodeModel)) || connPart instanceof DiagramImplicitConnectionPart) continue;
                this.deleteConnection(connPart);
            }
        }
    }

    private void deleteConnection(DiagramConnectionPart connPart) {
        IModelElement element = connPart.getLocalModelElement();
        ModelElementList list = (ModelElementList)element.parent();
        list.remove((Object)element);
    }

    private void deleteNode(DiagramNodePart nodePart) {
        IModelElement nodeModel = nodePart.getLocalModelElement();
        this.deleteNodeConnections(nodePart);
        SapphireDiagramEditorPagePart editorPart = nodePart.getDiagramNodeTemplate().getDiagramEditorPart();
        List<DiagramConnectionTemplate> connTemplates = editorPart.getConnectionTemplates();
        for (DiagramConnectionTemplate connTemplate : connTemplates) {
            IModelElement connParentElement;
            if (connTemplate.getConnectionType() != DiagramConnectionTemplate.ConnectionType.OneToMany || (connParentElement = connTemplate.getConnectionParentElement(nodeModel)) == null) continue;
            ModelElementList connParentList = (ModelElementList)connParentElement.parent();
            connParentList.remove((Object)connParentElement);
        }
        ModelElementList list = (ModelElementList)nodeModel.parent();
        list.remove((Object)nodeModel);
    }
}

