/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileExtensions;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.PathValidationService;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;

public final class CreateWorkspaceFileOpFileNameValidator
extends ValidationService {
    public Status validate() {
        Value value = ((IModelElement)this.context(IModelElement.class)).read((ValueProperty)this.context(ValueProperty.class));
        String fileName = value.getText();
        if (fileName != null) {
            CreateWorkspaceFileOp operation;
            IFile fileHandle;
            int lastDot = fileName.indexOf(46);
            if (lastDot >= 0 && lastDot < fileName.length()) {
                FileExtensions fileExtensionsAnnotation = (FileExtensions)value.getProperty().getAnnotation(FileExtensions.class);
                ArrayList<String> extensions = new ArrayList<String>();
                String[] stringArray = fileExtensionsAnnotation.expr().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    extensions.add(extension);
                    ++n2;
                }
                Status st = PathValidationService.validateExtensions((String)fileName, extensions);
                if (!st.ok()) {
                    return st;
                }
            }
            if ((fileHandle = (operation = (CreateWorkspaceFileOp)value.nearest(CreateWorkspaceFileOp.class)).getFileHandle()) != null && fileHandle.exists() && !((Boolean)operation.getOverwriteExistingFile().getContent()).booleanValue()) {
                String msg = NLS.bind((String)Resources.fileExists, (Object[])new Object[]{fileName});
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String fileExists;

        static {
            Resources.initializeMessages((String)CreateWorkspaceFileOpFileNameValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

