/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileExtensionsFactsService
extends FactsService {
    @Override
    protected void facts(List<String> facts) {
        FileExtensionsService service = this.context(IModelElement.class).service(this.context(ModelProperty.class), FileExtensionsService.class);
        List<String> extensions = service.extensions();
        int count = extensions.size();
        if (count > 0) {
            if (count == 1) {
                facts.add(NLS.bind(Resources.statementForOne, extensions.get(0)));
            } else if (count == 2) {
                facts.add(NLS.bind(Resources.statementForTwo, extensions.get(0), extensions.get(1)));
            } else if (count == 3) {
                facts.add(NLS.bind(Resources.statementForThree, extensions.get(0), extensions.get(1), extensions.get(2)));
            } else {
                StringBuilder buf = new StringBuilder();
                for (String extension : extensions) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append('\"');
                    buf.append(extension);
                    buf.append('\"');
                }
                facts.add(NLS.bind(Resources.statementForMany, buf.toString()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && context.find(IModelElement.class).service(property, FileExtensionsService.class) != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new FileExtensionsFactsService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String statementForOne;
        public static String statementForTwo;
        public static String statementForThree;
        public static String statementForMany;

        static {
            Resources.initializeMessages(FileExtensionsFactsService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

