/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutableReference<T> {
    private T value;
    private final ListenerContext listeners = new ListenerContext();

    public MutableReference() {
        this(null);
    }

    public MutableReference(T value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        MutableReference mutableReference = this;
        synchronized (mutableReference) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        T oldValue;
        MutableReference mutableReference = this;
        synchronized (mutableReference) {
            oldValue = this.value;
            this.value = value;
        }
        this.listeners.broadcast(new ReferenceChangedEvent(oldValue, value));
    }

    public boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ReferenceChangedEvent
    extends Event {
        private final T before;
        private final T after;

        private ReferenceChangedEvent(T before, T after) {
            this.before = before;
            this.after = after;
        }

        public T before() {
            return this.before;
        }

        public T after() {
            return this.after;
        }
    }
}

