/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.actions;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.swt.gef.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public final class SaveAsImageDiagramActionHandler
extends SapphireActionHandler {
    protected Object run(SapphireRenderingContext context) {
        DiagramRenderingContext diagramContext = (DiagramRenderingContext)context;
        SapphireDiagramEditor diagramEditor = diagramContext.getDiagramEditor();
        if (diagramEditor != null) {
            FileDialog dialog = new FileDialog(context.getShell(), 8192);
            IEditorInput editorInput = (IEditorInput)diagramEditor.getPart().adapt(IEditorInput.class);
            if (editorInput instanceof IFileEditorInput) {
                dialog.setFilterPath(((IFileEditorInput)editorInput).getFile().getParent().getLocation().toOSString());
            }
            String editorInputName = editorInput.getName();
            int editorInputLastDot = editorInputName.lastIndexOf(46);
            StringBuilder initialFileName = new StringBuilder();
            if (editorInputLastDot == -1) {
                initialFileName.append(editorInputName);
            } else {
                initialFileName.append(editorInputName.substring(0, editorInputLastDot));
            }
            initialFileName.append(".png");
            dialog.setFileName(initialFileName.toString());
            dialog.setFilterExtensions(new String[]{"*.png"});
            dialog.setText(Resources.saveAsImageMessage);
            dialog.setOverwrite(true);
            String filePath = dialog.open();
            if (filePath == null) {
                return null;
            }
            GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)graphicalViewer.getRootEditPart();
            IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
            Rectangle rectangle = figure.getBounds();
            Image image = new Image((Device)Display.getDefault(), rectangle.width, rectangle.height);
            GC gc = new GC((Drawable)image);
            SWTGraphics graphics = new SWTGraphics(gc);
            figure.paint((Graphics)graphics);
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            try {
                FileOutputStream output = new FileOutputStream(filePath);
                loader.save((OutputStream)output, 5);
                output.flush();
                output.close();
                image.dispose();
                gc.dispose();
                graphics.dispose();
            }
            catch (Exception e) {
                LoggingService.log((Exception)e);
            }
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String saveAsImageMessage;

        static {
            Resources.initializeMessages((String)SaveAsImageDiagramActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

