/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

public abstract class EqualsFactory {
    private static EqualsFactory TRUE = new TrueEqualsFactory();
    private static EqualsFactory FALSE = new FalseEqualsFactory();

    private EqualsFactory() {
    }

    public static EqualsFactory start() {
        return TRUE;
    }

    public abstract EqualsFactory add(Object var1, Object var2);

    public abstract boolean result();

    /* synthetic */ EqualsFactory(EqualsFactory equalsFactory) {
        this();
    }

    private static final class FalseEqualsFactory
    extends EqualsFactory {
        private FalseEqualsFactory() {
            super(null);
        }

        public EqualsFactory add(Object x, Object y) {
            return this;
        }

        public boolean result() {
            return false;
        }
    }

    private static final class TrueEqualsFactory
    extends EqualsFactory {
        private TrueEqualsFactory() {
            super(null);
        }

        public EqualsFactory add(Object x, Object y) {
            if (x == y) {
                return TRUE;
            }
            if (x != null && y != null) {
                return x.equals(y) ? TRUE : FALSE;
            }
            return FALSE;
        }

        public boolean result() {
            return true;
        }
    }
}

