/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.layout.standard;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.StatusException;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionBendPoints;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;
import org.eclipse.sapphire.ui.diagram.layout.ConnectionHashKey;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramBendPointLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramConnectionLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.DiagramNodeLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayout;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public abstract class StandardDiagramLayoutPersistenceService
extends DiagramLayoutPersistenceService {
    protected StandardDiagramLayout layoutModel;
    protected IEditorInput editorInput;
    private SapphireDiagramPartListener diagramPartListener;
    private Map<String, DiagramNodeBounds> nodeBounds;
    private Map<ConnectionHashKey, DiagramConnectionBendPoints> connectionBendPoints;
    private Map<ConnectionHashKey, Point> connectionLabelPositions;
    private boolean dirty;

    protected void init() {
        super.init();
        this.editorInput = (IEditorInput)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getLocalModelElement().adapt(IEditorInput.class);
        this.nodeBounds = new HashMap<String, DiagramNodeBounds>();
        this.connectionBendPoints = new HashMap<ConnectionHashKey, DiagramConnectionBendPoints>();
        this.connectionLabelPositions = new HashMap<ConnectionHashKey, Point>();
        this.dirty = false;
        try {
            this.load();
            this.refreshPersistedPartsCache();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        this.addDiagramPartListener();
    }

    public void dispose() {
        if (this.diagramPartListener != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).removeListener(this.diagramPartListener);
        }
    }

    protected abstract StandardDiagramLayout initLayoutModel();

    public void load() throws ResourceStoreException, CoreException, IOException, StatusException {
        this.layoutModel = this.initLayoutModel();
        if (this.layoutModel == null) {
            return;
        }
        Boolean gridVisible = (Boolean)this.layoutModel.getGridLayout().isVisible().getContent();
        Boolean showGuides = (Boolean)this.layoutModel.getGuidesLayout().isVisible().getContent();
        if (gridVisible != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setGridVisible(gridVisible);
        }
        if (showGuides != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setShowGuides(showGuides);
        }
        ModelElementList<DiagramNodeLayout> nodes = this.layoutModel.getDiagramNodesLayout();
        for (DiagramNodeLayout node : nodes) {
            String nodeId = (String)node.getNodeId().getContent();
            DiagramNodePart nodePart = IdUtil.getNodePart((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class), nodeId);
            int x = (Integer)node.getX().getContent();
            int y = (Integer)node.getY().getContent();
            int width = (Integer)node.getWidth().getContent();
            int height = (Integer)node.getHeight().getContent();
            if (nodePart != null) {
                nodePart.setNodeBounds(new DiagramNodeBounds(x, y, width, height, false, false));
            }
            ModelElementList<DiagramConnectionLayout> connList = node.getEmbeddedConnectionsLayout();
            for (DiagramConnectionLayout connLayout : connList) {
                String connId = (String)connLayout.getConnectionId().getContent();
                ModelElementList<DiagramBendPointLayout> bps = connLayout.getConnectionBendpoints();
                DiagramConnectionPart connPart = IdUtil.getConnectionPart(nodePart, connId);
                if (connPart == null) continue;
                int index = 0;
                for (DiagramBendPointLayout pt : bps) {
                    connPart.addBendpoint(index++, (Integer)pt.getX().getContent(), (Integer)pt.getY().getContent());
                }
                if (connLayout.getLabelX().getContent(false) == null || connLayout.getLabelY().getContent(false) == null) continue;
                Point labelPos = new Point((Integer)connLayout.getLabelX().getContent(), (Integer)connLayout.getLabelY().getContent());
                connPart.setLabelPosition(labelPos);
            }
        }
        ModelElementList<DiagramConnectionLayout> connList = this.layoutModel.getDiagramConnectionsLayout();
        for (DiagramConnectionLayout connLayout : connList) {
            String connId = (String)connLayout.getConnectionId().getContent();
            DiagramConnectionPart connPart = IdUtil.getConnectionPart((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class), connId);
            ModelElementList<DiagramBendPointLayout> bps = connLayout.getConnectionBendpoints();
            if (connPart == null) continue;
            int index = 0;
            for (DiagramBendPointLayout pt : bps) {
                connPart.addBendpoint(index++, (Integer)pt.getX().getContent(), (Integer)pt.getY().getContent());
            }
            ArrayList<Point> bendPoints = new ArrayList<Point>();
            bendPoints.addAll(connPart.getConnectionBendpoints().getBendPoints());
            if (connLayout.getLabelX().getContent(false) == null || connLayout.getLabelY().getContent(false) == null) continue;
            Point labelPos = new Point((Integer)connLayout.getLabelX().getContent(), (Integer)connLayout.getLabelY().getContent());
            connPart.setLabelPosition(labelPos);
        }
    }

    protected String computeLayoutFileName(IEditorInput editorInput) throws CoreException, IOException {
        IStorageEditorInput storageEditorInput;
        IPath storagePath;
        String uniquePath = null;
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            IFile ifile = fileEditorInput.getFile();
            uniquePath = ifile.getLocation().toPortableString();
        } else if (editorInput instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreInput = (FileStoreEditorInput)editorInput;
            IFileStore store = EFS.getStore((URI)fileStoreInput.getURI());
            File localFile = store.toLocalFile(0, null);
            if (localFile == null) {
                localFile = store.toLocalFile(4096, null);
            }
            if (localFile == null) {
                throw new IllegalArgumentException();
            }
            uniquePath = localFile.getCanonicalPath();
        } else if (editorInput instanceof IStorageEditorInput && (storagePath = (storageEditorInput = (IStorageEditorInput)editorInput).getStorage().getFullPath()) != null) {
            uniquePath = storagePath.toPortableString();
        }
        return uniquePath != null ? MiscUtil.createStringDigest((String)uniquePath) : null;
    }

    public void save() {
        if (this.layoutModel == null) {
            return;
        }
        this.addNodeBoundsToModel();
        this.addConnectionsToModel();
        this.refreshPersistedPartsCache();
        try {
            this.layoutModel.resource().save();
        }
        catch (ResourceStoreException rse) {
            SapphireUiFrameworkPlugin.log(rse);
        }
    }

    private void read(DiagramNodePart nodePart) {
        String id = IdUtil.computeNodeId(nodePart);
        if (this.nodeBounds.containsKey(id) && this.nodeBounds.get(id) != null) {
            nodePart.setNodeBounds(this.nodeBounds.get(id));
        }
    }

    private void write(DiagramNodePart nodePart) {
        this.refreshDirtyState();
    }

    private void read(DiagramConnectionPart connPart) {
        ConnectionHashKey key = ConnectionHashKey.createKey(connPart);
        if (this.connectionBendPoints.containsKey(key)) {
            Point labelPos;
            if (this.connectionBendPoints.get(key) != null) {
                connPart.resetBendpoints(this.connectionBendPoints.get(key));
            }
            if ((labelPos = this.connectionLabelPositions.get(key)) != null) {
                connPart.setLabelPosition(new Point(labelPos.getX(), labelPos.getY()));
            }
        }
    }

    private void write(DiagramConnectionPart connPart) {
        this.refreshDirtyState();
    }

    private void setGridVisible(boolean visible) {
        if (this.layoutModel != null) {
            this.layoutModel.getGridLayout().setVisible(visible);
        }
    }

    private void setGuidesVisible(boolean visible) {
        if (this.layoutModel != null) {
            this.layoutModel.getGuidesLayout().setVisible(visible);
        }
    }

    private void addNodeBoundsToModel() {
        this.layoutModel.getDiagramNodesLayout().clear();
        for (DiagramNodeTemplate nodeTemplate : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodeTemplates()) {
            for (DiagramNodePart nodePart : nodeTemplate.getDiagramNodes()) {
                DiagramEmbeddedConnectionTemplate embeddedConnTemplate;
                String nodeId = IdUtil.computeNodeId(nodePart);
                DiagramNodeLayout diagramNode = (DiagramNodeLayout)this.layoutModel.getDiagramNodesLayout().insert();
                diagramNode.setNodeId(nodeId);
                DiagramNodeBounds bounds = nodePart.getNodeBounds();
                diagramNode.setX(bounds.getX());
                diagramNode.setY(bounds.getY());
                if (nodePart.canResizeShape()) {
                    if (bounds.getHeight() != -1) {
                        diagramNode.setHeight(bounds.getHeight());
                    }
                    if (bounds.getWidth() != -1) {
                        diagramNode.setWidth(bounds.getWidth());
                    }
                }
                if ((embeddedConnTemplate = nodePart.getDiagramNodeTemplate().getEmbeddedConnectionTemplate()) == null) continue;
                diagramNode.getEmbeddedConnectionsLayout().clear();
                List<DiagramConnectionPart> connParts = embeddedConnTemplate.getDiagramConnections(nodePart.getLocalModelElement());
                for (DiagramConnectionPart connPart : connParts) {
                    String connId = IdUtil.computeConnectionId(connPart);
                    DiagramConnectionLayout conn = null;
                    DiagramConnectionBendPoints connBendPoints = connPart.getConnectionBendpoints();
                    if (connBendPoints.size() > 0) {
                        conn = (DiagramConnectionLayout)diagramNode.getEmbeddedConnectionsLayout().insert();
                        conn.setConnectionId(connId);
                        for (Point pt : connBendPoints.getBendPoints()) {
                            DiagramBendPointLayout pt2 = (DiagramBendPointLayout)conn.getConnectionBendpoints().insert();
                            pt2.setX(pt.getX());
                            pt2.setY(pt.getY());
                        }
                    }
                    if (connPart.getLabel() == null || connPart.getLabelPosition() == null) continue;
                    if (conn == null) {
                        conn = (DiagramConnectionLayout)diagramNode.getEmbeddedConnectionsLayout().insert();
                        conn.setConnectionId(connId);
                    }
                    conn.setLabelX(connPart.getLabelPosition().getX());
                    conn.setLabelY(connPart.getLabelPosition().getY());
                }
            }
        }
    }

    private void addConnectionsToModel() {
        this.layoutModel.getDiagramConnectionsLayout().clear();
        for (DiagramConnectionTemplate connTemplate : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getConnectionTemplates()) {
            for (DiagramConnectionPart connPart : connTemplate.getDiagramConnections(null)) {
                String id = IdUtil.computeConnectionId(connPart);
                DiagramConnectionLayout conn = null;
                DiagramConnectionBendPoints connBendPoints = connPart.getConnectionBendpoints();
                if (connBendPoints.size() > 0) {
                    conn = (DiagramConnectionLayout)this.layoutModel.getDiagramConnectionsLayout().insert();
                    conn.setConnectionId(id);
                    for (Point pt : connBendPoints.getBendPoints()) {
                        DiagramBendPointLayout pt2 = (DiagramBendPointLayout)conn.getConnectionBendpoints().insert();
                        pt2.setX(pt.getX());
                        pt2.setY(pt.getY());
                    }
                }
                if (connPart.getLabel() == null || connPart.getLabelPosition() == null) continue;
                if (conn == null) {
                    conn = (DiagramConnectionLayout)this.layoutModel.getDiagramConnectionsLayout().insert();
                    conn.setConnectionId(id);
                }
                conn.setLabelX(connPart.getLabelPosition().getX());
                conn.setLabelY(connPart.getLabelPosition().getY());
            }
        }
    }

    private void addNodeToPersistenceCache(DiagramNodePart nodePart) {
        String nodeId = IdUtil.computeNodeId(nodePart);
        this.nodeBounds.put(nodeId, nodePart.getNodeBounds());
    }

    private void addConnectionToPersistenceCache(DiagramConnectionPart connPart) {
        ConnectionHashKey connKey = ConnectionHashKey.createKey(connPart);
        this.connectionBendPoints.put(connKey, connPart.getConnectionBendpoints());
        if (connPart.getLabel() != null && connPart.getLabelPosition() != null) {
            this.connectionLabelPositions.put(connKey, new Point(connPart.getLabelPosition()));
        }
    }

    private void refreshPersistedPartsCache() {
        this.nodeBounds.clear();
        this.connectionBendPoints.clear();
        for (DiagramConnectionPart connPart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getConnections()) {
            this.addConnectionToPersistenceCache(connPart);
        }
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            this.addNodeToPersistenceCache(nodePart);
        }
    }

    private void addDiagramPartListener() {
        this.diagramPartListener = new SapphireDiagramPartListener(){

            public void handleGridStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.getPart();
                StandardDiagramLayoutPersistenceService.this.setGridVisible(diagramPart.isGridVisible());
            }

            public void handleGuideStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.getPart();
                StandardDiagramLayoutPersistenceService.this.setGuidesVisible(diagramPart.isShowGuides());
            }

            public void handleNodeAddEvent(DiagramNodeEvent event) {
                DiagramNodePart nodePart = (DiagramNodePart)event.getPart();
                StandardDiagramLayoutPersistenceService.this.read(nodePart);
            }

            public void handleNodeMoveEvent(DiagramNodeEvent event) {
                DiagramNodePart nodePart = (DiagramNodePart)event.getPart();
                DiagramNodeBounds nodeBounds = nodePart.getNodeBounds();
                if (nodeBounds.isAutoLayout()) {
                    StandardDiagramLayoutPersistenceService.this.addNodeToPersistenceCache(nodePart);
                    StandardDiagramLayoutPersistenceService.this.refreshDirtyState();
                } else if (!nodeBounds.isDefaultPosition()) {
                    StandardDiagramLayoutPersistenceService.this.write((DiagramNodePart)event.getPart());
                }
            }

            public void handleNodeDeleteEvent(DiagramNodeEvent event) {
                StandardDiagramLayoutPersistenceService.this.refreshDirtyState();
            }

            public void handleConnectionAddEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                StandardDiagramLayoutPersistenceService.this.read(connPart);
            }

            public void handleConnectionDeleteEvent(DiagramConnectionEvent event) {
                StandardDiagramLayoutPersistenceService.this.refreshDirtyState();
            }

            public void handleConnectionAddBendpointEvent(DiagramConnectionEvent event) {
                StandardDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionRemoveBendpointEvent(DiagramConnectionEvent event) {
                StandardDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionMoveBendpointEvent(DiagramConnectionEvent event) {
                StandardDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionResetBendpointsEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                DiagramConnectionBendPoints bendPoints = connPart.getConnectionBendpoints();
                if (bendPoints.isAutoLayout()) {
                    StandardDiagramLayoutPersistenceService.this.addConnectionToPersistenceCache(connPart);
                    StandardDiagramLayoutPersistenceService.this.refreshDirtyState();
                } else if (bendPoints.isDefault()) {
                    StandardDiagramLayoutPersistenceService.this.read(connPart);
                } else {
                    StandardDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
                }
            }

            public void handleConnectionMoveLabelEvent(DiagramConnectionEvent event) {
                StandardDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
            }

            public void handleDiagramSaveEvent(DiagramPageEvent event) {
                StandardDiagramLayoutPersistenceService.this.save();
            }
        };
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).addListener(this.diagramPartListener);
    }

    private boolean isNodeLayoutChanged(DiagramNodePart nodePart) {
        DiagramNodeBounds newBounds = nodePart.getNodeBounds();
        boolean changed = false;
        String nodeId = IdUtil.computeNodeId(nodePart);
        if (this.nodeBounds.containsKey(nodeId)) {
            DiagramNodeBounds oldBounds = this.nodeBounds.get(nodeId);
            if (!newBounds.equals(oldBounds)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isConnectionLayoutChanged(DiagramConnectionPart connPart) {
        DiagramConnectionBendPoints bendpoints = connPart.getConnectionBendpoints();
        ConnectionHashKey key = ConnectionHashKey.createKey(connPart);
        boolean changed = false;
        if (this.connectionBendPoints.containsKey(key)) {
            DiagramConnectionBendPoints oldBendpoints = this.connectionBendPoints.get(key);
            if (!bendpoints.equals(oldBendpoints)) {
                changed = true;
            }
            if (!changed && connPart.getLabel() != null) {
                Point newPos = connPart.getLabelPosition();
                Point oldPos = this.connectionLabelPositions.get(key);
                if (newPos == null && oldPos != null || newPos != null && oldPos == null || newPos != null && oldPos != null && !newPos.equals(oldPos)) {
                    changed = true;
                }
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isDiagramLayoutChanged() {
        boolean changed = false;
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            if (nodePart.getLocalModelElement().disposed() || !this.isNodeLayoutChanged(nodePart)) continue;
            changed = true;
            break;
        }
        for (DiagramConnectionPart connPart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getConnections()) {
            if (connPart.getLocalModelElement().disposed() || !this.isConnectionLayoutChanged(connPart)) continue;
            changed = true;
            break;
        }
        return changed;
    }

    public boolean dirty() {
        return this.dirty;
    }

    private void refreshDirtyState() {
        boolean after = this.isDiagramLayoutChanged();
        if (this.dirty != after) {
            boolean before = this.dirty;
            this.dirty = after;
            this.broadcast(new DiagramLayoutPersistenceService.DirtyStateEvent(this, before, after));
        }
    }
}

