/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SectionPart;
import org.eclipse.sapphire.ui.def.ISapphireParam;
import org.eclipse.sapphire.ui.def.SectionDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNodeList;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.MasterDetailsContentNodeChildDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.MasterDetailsContentNodeDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.MasterDetailsContentNodeFactoryCaseDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.MasterDetailsContentNodeFactoryDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.MasterDetailsContentNodeInclude;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.util.MapFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsContentNode
extends SapphirePart
implements IPropertiesViewContributorPart {
    private static final ImageData IMG_CONTAINER_NODE = ImageData.createFromClassLoader(MasterDetailsContentNode.class, (String)"ContainerNode.png");
    private static final ImageData IMG_LEAF_NODE = ImageData.createFromClassLoader(MasterDetailsContentNode.class, (String)"LeafNode.png");
    private MasterDetailsContentOutline contentTree;
    private MasterDetailsContentNodeDef definition;
    private IModelElement modelElement;
    private ImpliedElementProperty modelElementProperty;
    private Listener modelElementListener;
    private MasterDetailsContentNode parentNode;
    private FunctionResult labelFunctionResult;
    private SapphirePart.ImageManager imageManager;
    private Listener childPartListener;
    private List<Object> rawChildren;
    private MasterDetailsContentNodeList nodes;
    private List<SectionPart> sections;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private boolean expanded;
    private boolean transformLabelCase = true;
    private final Function nodeFactoryVisibleFunction;

    public MasterDetailsContentNode() {
        this(null);
    }

    public MasterDetailsContentNode(Function nodeFactoryVisibleFunction) {
        this.nodeFactoryVisibleFunction = nodeFactoryVisibleFunction;
    }

    @Override
    protected void init() {
        super.init();
        ISapphirePart parent = this.getParentPart();
        this.parentNode = parent instanceof MasterDetailsContentNode ? (MasterDetailsContentNode)parent : null;
        this.contentTree = this.nearest(MasterDetailsEditorPagePart.class).outline();
        this.definition = (MasterDetailsContentNodeDef)((SapphirePart)this).definition;
        this.modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.definition.getProperty().getContent());
        if (this.modelElementProperty != null) {
            this.modelElement = this.getModelElement().read((ElementProperty)this.modelElementProperty).element();
            this.modelElementListener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    MasterDetailsContentNode.this.handleModelElementChange((Event)event);
                }
            };
            this.modelElement.attach(this.modelElementListener);
        } else {
            this.modelElement = this.getModelElement();
        }
        this.expanded = false;
        FilteredListener<ElementValidationEvent> elementValidationListener = new FilteredListener<ElementValidationEvent>(){

            protected void handleTypedEvent(ElementValidationEvent event) {
                MasterDetailsContentNode.this.refreshValidation();
            }
        };
        this.modelElement.attach((Listener)elementValidationListener);
        this.childPartListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof PartValidationEvent || event instanceof PartVisibilityEvent) {
                    MasterDetailsContentNode.this.refreshValidation();
                }
            }
        };
        this.labelFunctionResult = this.initExpression(this.modelElement, (Function)this.definition.getLabel().getContent(), String.class, null, new Runnable(){

            public void run() {
                MasterDetailsContentNode.this.broadcast(new SapphirePart.LabelChangedEvent(MasterDetailsContentNode.this));
            }
        });
        Literal defaultImageLiteral = Literal.create((Object)(this.definition.getChildNodes().isEmpty() ? IMG_LEAF_NODE : IMG_CONTAINER_NODE));
        Function imageFunction = (Function)this.definition.getImage().getContent();
        this.imageManager = new SapphirePart.ImageManager(this.modelElement, imageFunction, (Function)defaultImageLiteral);
        this.rawChildren = new ArrayList<Object>();
        ListFactory sectionsListFactory = ListFactory.start();
        for (SectionDef secdef : this.definition.getSections()) {
            SectionPart section = new SectionPart(){

                protected Object createSectionLayoutData() {
                    return TableWrapLayoutUtil.twd();
                }
            };
            section.init(this, this.modelElement, secdef, this.params);
            section.attach(this.childPartListener);
            sectionsListFactory.add((Object)section);
        }
        this.sections = sectionsListFactory.result();
        for (MasterDetailsContentNodeChildDef entry : this.definition.getChildNodes()) {
            HashMap<String, String> params = new HashMap<String, String>(this.params);
            if (entry instanceof MasterDetailsContentNodeInclude) {
                MasterDetailsContentNodeInclude inc = (MasterDetailsContentNodeInclude)entry;
                if ((entry = inc.resolve()) == null) {
                    String msg = NLS.bind((String)Resources.couldNotResolveNode, (Object[])new Object[]{inc.getPart()});
                    throw new RuntimeException(msg);
                }
                for (ISapphireParam param : inc.getParams()) {
                    String paramName = param.getName().getText();
                    String paramValue = param.getValue().getText();
                    if (paramName == null || paramValue == null) continue;
                    params.put(paramName, paramValue);
                }
            }
            if (entry instanceof MasterDetailsContentNodeDef) {
                MasterDetailsContentNodeDef def = (MasterDetailsContentNodeDef)entry;
                MasterDetailsContentNode node = new MasterDetailsContentNode();
                node.init(this, this.modelElement, def, params);
                node.attach(this.childPartListener);
                this.rawChildren.add(node);
                continue;
            }
            if (entry instanceof MasterDetailsContentNodeFactoryDef) {
                NodeFactory factory = new NodeFactory(this.getLocalModelElement(), (MasterDetailsContentNodeFactoryDef)entry, params);
                this.rawChildren.add(factory);
                continue;
            }
            throw new IllegalStateException();
        }
        this.refreshNodes();
        this.attach(new Listener((Listener)elementValidationListener){
            private final /* synthetic */ Listener val$elementValidationListener;
            {
                this.val$elementValidationListener = listener;
            }

            public void handle(Event event) {
                if (event instanceof PartVisibilityEvent || event instanceof NodeListEvent) {
                    MasterDetailsContentNode.this.getContentTree().refreshSelection();
                } else if (event instanceof DisposeEvent) {
                    MasterDetailsContentNode.this.getModelElement().detach(this.val$elementValidationListener);
                }
            }
        });
    }

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), MasterDetailsContentNode.createVersionCompatibleFunction(this.getModelElement(), (ModelProperty)this.modelElementProperty), this.nodeFactoryVisibleFunction != null ? this.nodeFactoryVisibleFunction : new Function(){

            public String name() {
                return "VisibleIfChildrenVisible";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected void init() {
                        FilteredListener<PartVisibilityEvent> listener = new FilteredListener<PartVisibilityEvent>(){

                            protected void handleTypedEvent(PartVisibilityEvent event) {
                                this.refresh();
                            }
                        };
                        for (SapphirePart sapphirePart : MasterDetailsContentNode.this.getSections()) {
                            sapphirePart.attach((Listener)listener);
                        }
                        for (SectionPart sectionPart : MasterDetailsContentNode.this.rawChildren) {
                            if (sectionPart instanceof MasterDetailsContentNode) {
                                ((MasterDetailsContentNode)((Object)sectionPart)).attach((Listener)listener);
                                continue;
                            }
                            if (!(sectionPart instanceof NodeFactory)) continue;
                            ((NodeFactory)((Object)sectionPart)).attach((Listener)listener);
                        }
                    }

                    protected Object evaluate() {
                        boolean visible = false;
                        for (SectionPart section : MasterDetailsContentNode.this.getSections()) {
                            if (!section.visible()) continue;
                            visible = true;
                            break;
                        }
                        if (!visible) {
                            boolean bl = visible = MasterDetailsContentNode.this.getChildNodeFactoryProperties().size() > 0;
                        }
                        if (!visible) {
                            for (SectionPart entry : MasterDetailsContentNode.this.rawChildren) {
                                MasterDetailsContentNode node;
                                if (!(entry instanceof MasterDetailsContentNode) || !(node = (MasterDetailsContentNode)((Object)entry)).visible()) continue;
                                visible = true;
                                break;
                            }
                        }
                        return visible;
                    }
                };
            }
        }});
    }

    public MasterDetailsContentOutline getContentTree() {
        return this.contentTree;
    }

    public MasterDetailsContentNode getParentNode() {
        return this.parentNode;
    }

    public boolean isAncestorOf(MasterDetailsContentNode node) {
        MasterDetailsContentNode n = node;
        while (n != null) {
            if (n == this) {
                return true;
            }
            n = n.getParentNode();
        }
        return false;
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        if (label == null) {
            label = "#null#";
        } else {
            label = label.trim();
            CapitalizationType capType = this.transformLabelCase ? CapitalizationType.TITLE_STYLE : CapitalizationType.NO_CAPS;
            label = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(label, capType, false);
        }
        return label;
    }

    public ImageDescriptor getImage() {
        return this.imageManager.getImage();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, false);
    }

    public void setExpanded(boolean expanded, boolean applyToChildren) {
        if (this.parentNode != null && !this.parentNode.isExpanded() && expanded) {
            this.parentNode.setExpanded(true);
        }
        if (this.expanded != expanded) {
            MasterDetailsContentNode selection;
            if (!expanded && (selection = this.getContentTree().getSelectedNode()) != null && this.isAncestorOf(selection)) {
                this.select();
            }
            if (expanded) {
                this.expanded = expanded;
                this.getContentTree().notifyOfNodeExpandedStateChange(this);
            }
        }
        if (applyToChildren) {
            for (MasterDetailsContentNode child : this.nodes()) {
                if (child.nodes().visible().isEmpty()) continue;
                child.setExpanded(expanded, applyToChildren);
            }
        }
        if (this.expanded != expanded && !expanded) {
            this.expanded = expanded;
            this.getContentTree().notifyOfNodeExpandedStateChange(this);
        }
    }

    public List<MasterDetailsContentNode> getExpandedNodes() {
        ArrayList<MasterDetailsContentNode> result = new ArrayList<MasterDetailsContentNode>();
        this.getExpandedNodes(result);
        return result;
    }

    public void getExpandedNodes(List<MasterDetailsContentNode> result) {
        if (this.isExpanded()) {
            result.add(this);
            for (MasterDetailsContentNode child : this.nodes()) {
                child.getExpandedNodes(result);
            }
        }
    }

    public void select() {
        this.getContentTree().setSelectedNode(this);
    }

    public List<SectionPart> getSections() {
        return this.sections;
    }

    public List<ModelProperty> getChildNodeFactoryProperties() {
        ArrayList<ModelProperty> properties = new ArrayList<ModelProperty>();
        for (Object object : this.rawChildren) {
            NodeFactory factory;
            if (!(object instanceof NodeFactory) || !(factory = (NodeFactory)object).visible()) continue;
            properties.add(factory.property());
        }
        return properties;
    }

    public boolean isChildNodeFactoryProperty(ModelProperty property) {
        if (this.rawChildren != null) {
            for (Object object : this.rawChildren) {
                NodeFactory factory;
                if (!(object instanceof NodeFactory) || !(factory = (NodeFactory)object).visible() || factory.property() != property) continue;
                return true;
            }
        }
        return false;
    }

    public List<NodeFactory> factories() {
        ListFactory factories = ListFactory.start();
        for (Object entry : this.rawChildren) {
            if (!(entry instanceof NodeFactory)) continue;
            factories.add((Object)((NodeFactory)entry));
        }
        return factories.result();
    }

    public MasterDetailsContentNodeList nodes() {
        if (this.nodes == null) {
            this.nodes = new MasterDetailsContentNodeList(Collections.<MasterDetailsContentNode>emptyList());
        }
        return this.nodes;
    }

    public MasterDetailsContentNode findNode(String label) {
        for (MasterDetailsContentNode child : this.nodes()) {
            if (!label.equals(child.getLabel())) continue;
            return child;
        }
        return null;
    }

    public MasterDetailsContentNode findNode(IModelElement element) {
        if (this.getModelElement() == element) {
            return this;
        }
        for (MasterDetailsContentNode child : this.nodes()) {
            MasterDetailsContentNode res = child.findNode(element);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private void refreshNodes() {
        ListFactory nodeListFactory = ListFactory.start();
        for (Object entry : this.rawChildren) {
            if (entry instanceof MasterDetailsContentNode) {
                nodeListFactory.add((Object)((MasterDetailsContentNode)entry));
                continue;
            }
            if (entry instanceof NodeFactory) {
                nodeListFactory.add(((NodeFactory)entry).nodes());
                continue;
            }
            throw new IllegalStateException(entry.getClass().getName());
        }
        MasterDetailsContentNodeList nodes = new MasterDetailsContentNodeList(nodeListFactory.result());
        if (this.nodes == null) {
            this.nodes = nodes;
        } else if (!this.nodes.equals(nodes)) {
            this.nodes = nodes;
            this.broadcast(new NodeListEvent(this));
        }
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.EditorPage.Outline.Node");
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        if (this.basis()) {
            factory.merge(this.getModelElement().validation());
        }
        for (SapphirePart sapphirePart : this.sections) {
            if (!sapphirePart.visible()) continue;
            factory.merge(sapphirePart.validation());
        }
        for (SapphirePart sapphirePart : this.nodes()) {
            if (!sapphirePart.visible()) continue;
            factory.merge(sapphirePart.validation());
        }
        return factory.create();
    }

    private boolean basis() {
        ISapphirePart parentPart;
        IModelElement element = this.getModelElement();
        if (element.parent() instanceof ModelElementList && (parentPart = this.getParentPart()) != null && parentPart instanceof MasterDetailsContentNode) {
            MasterDetailsContentNode parentNode = (MasterDetailsContentNode)parentPart;
            return element != parentNode.getLocalModelElement();
        }
        return false;
    }

    @Override
    protected void handleModelElementChange(Event event) {
        super.handleModelElementChange(event);
        if (event instanceof PropertyEvent && this.isChildNodeFactoryProperty(((PropertyEvent)event).property())) {
            if (event instanceof PropertyContentEvent) {
                this.refreshNodes();
            } else if (event instanceof PropertyValidationEvent) {
                SwtUtil.runOnDisplayThread(new Runnable(){

                    public void run() {
                        MasterDetailsContentNode.this.refreshValidation();
                    }
                });
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.modelElementListener != null) {
            this.modelElement.detach(this.modelElementListener);
        }
        for (SapphirePart sapphirePart : this.sections) {
            sapphirePart.dispose();
        }
        for (SapphirePart sapphirePart : this.nodes()) {
            sapphirePart.dispose();
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.imageManager != null) {
            this.imageManager.dispose();
        }
        for (Object object : this.rawChildren) {
            if (!(object instanceof NodeFactory)) continue;
            ((NodeFactory)object).dispose();
        }
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    public boolean controls(IModelElement element) {
        ISapphirePart parentPart;
        if (element == this.getModelElement() && (parentPart = this.getParentPart()) != null && parentPart instanceof MasterDetailsContentNode) {
            MasterDetailsContentNode parentNode = (MasterDetailsContentNode)parentPart;
            return element != parentNode.getLocalModelElement();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class NodeFactory {
        private final IModelElement element;
        private final ModelProperty property;
        private final MasterDetailsContentNodeFactoryDef definition;
        private final Map<String, String> params;
        private final FunctionResult visibleWhenFunctionResult;
        private final Function visibleWhenFunctionForNodes;
        private final Map<IModelElement, MasterDetailsContentNode> nodesCache = new IdentityHashMap<IModelElement, MasterDetailsContentNode>();
        private final ListenerContext listeners = new ListenerContext();

        public NodeFactory(IModelElement element, MasterDetailsContentNodeFactoryDef definition, Map<String, String> params) {
            this.element = element;
            this.property = MasterDetailsContentNode.resolve(element, (String)definition.getProperty().getContent(), params);
            this.definition = definition;
            this.params = params;
            if (this.property instanceof ValueProperty || this.property instanceof ImpliedElementProperty || this.property instanceof TransientProperty) {
                throw new IllegalArgumentException();
            }
            this.visibleWhenFunctionResult = MasterDetailsContentNode.this.initExpression(this.element, AndFunction.create((Function[])new Function[]{(Function)definition.getVisibleWhen().getContent(), MasterDetailsContentNode.createVersionCompatibleFunction(this.element, this.property)}), Boolean.class, (Function)Literal.TRUE, new Runnable(){

                public void run() {
                    NodeFactory.this.broadcast(new PartVisibilityEvent(null));
                }
            });
            this.visibleWhenFunctionForNodes = new Function(){

                public String name() {
                    return "NodeFactoryVisible";
                }

                public FunctionResult evaluate(FunctionContext context) {
                    return new FunctionResult(this, context){
                        private Listener listener;

                        protected void init() {
                            this.listener = new Listener(){

                                public void handle(Event event) {
                                    this.refresh();
                                }
                            };
                            NodeFactory.this.visibleWhenFunctionResult.attach(this.listener);
                        }

                        protected Object evaluate() {
                            return NodeFactory.this.visible();
                        }

                        public void dispose() {
                            super.dispose();
                            NodeFactory.this.visibleWhenFunctionResult.detach(this.listener);
                        }
                    };
                }
            };
            this.visibleWhenFunctionForNodes.init(new Function[0]);
        }

        public final boolean visible() {
            return (Boolean)this.visibleWhenFunctionResult.value();
        }

        public ModelProperty property() {
            return this.property;
        }

        protected List<IModelElement> elements() {
            ListFactory elementsListFactory = ListFactory.start();
            if (this.property instanceof ListProperty) {
                elementsListFactory.add((Collection)this.element.read((ListProperty)this.property));
            } else {
                elementsListFactory.add((Object)this.element.read((ElementProperty)this.property).element());
            }
            return elementsListFactory.result();
        }

        public final List<MasterDetailsContentNode> nodes() {
            Map oldCache = MapFactory.unmodifiable(this.nodesCache);
            ListFactory nodes = ListFactory.start();
            for (IModelElement element : this.elements()) {
                MasterDetailsContentNode node = this.nodesCache.get(element);
                if (node == null) {
                    MasterDetailsContentNodeFactoryCaseDef relevantCaseDef = null;
                    for (MasterDetailsContentNodeFactoryCaseDef entry : this.definition.getCases()) {
                        JavaType type = (JavaType)entry.getType().resolve();
                        if (type == null) {
                            relevantCaseDef = entry;
                            break;
                        }
                        Class cl = type.artifact();
                        if (cl != null && !cl.isAssignableFrom(element.getClass())) continue;
                        relevantCaseDef = entry;
                        break;
                    }
                    if (relevantCaseDef == null) {
                        throw new RuntimeException();
                    }
                    node = new MasterDetailsContentNode(this.visibleWhenFunctionForNodes);
                    this.nodesCache.put(element, node);
                    node.init(MasterDetailsContentNode.this, element, relevantCaseDef, this.params);
                    node.attach(MasterDetailsContentNode.this.childPartListener);
                    node.transformLabelCase = false;
                }
                nodes.add((Object)node);
            }
            for (Map.Entry entry : oldCache.entrySet()) {
                if (this.nodesCache.containsKey(entry.getKey())) continue;
                ((MasterDetailsContentNode)entry.getValue()).dispose();
            }
            return nodes.result();
        }

        public final boolean attach(Listener listener) {
            return this.listeners.attach(listener);
        }

        public final boolean detach(Listener listener) {
            return this.listeners.detach(listener);
        }

        protected final void broadcast(Event event) {
            this.listeners.broadcast(event);
        }

        public void dispose() {
            if (this.visibleWhenFunctionResult != null) {
                this.visibleWhenFunctionResult.dispose();
            }
        }
    }

    public static final class NodeListEvent
    extends SapphirePart.PartEvent {
        public NodeListEvent(MasterDetailsContentNode node) {
            super(node);
        }

        public MasterDetailsContentNode part() {
            return (MasterDetailsContentNode)super.part();
        }
    }

    private static final class Resources
    extends NLS {
        public static String couldNotResolveNode;

        static {
            Resources.initializeMessages((String)MasterDetailsContentNode.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

