/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StateCodePossibleValuesService
extends PossibleValuesService {
    protected void fillPossibleValues(SortedSet<String> values) {
        Address address = (Address)this.context(Address.class);
        String zipCode = address.getZipCode().getText();
        String city = address.getCity().getText();
        values.addAll(ZipCodeRepository.getStateCodes(zipCode, city));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return NLS.bind((String)"\"{0}\" is not a valid state postal code for the specified city and ZIP code.", (Object[])new Object[]{invalidValue});
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

