/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.samples.architecture.ArchitectureSketch;
import org.eclipse.sapphire.samples.architecture.Component;
import org.eclipse.sapphire.samples.architecture.ComponentDependency;
import org.eclipse.sapphire.samples.architecture.ConnectionBendpoint;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceEvent;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionBendPoints;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;
import org.eclipse.sapphire.ui.diagram.layout.ConnectionHashKey;
import org.eclipse.sapphire.ui.diagram.layout.DiagramLayoutPersistenceService;

public class ArchitectureDiagramLayoutPersistenceService
extends DiagramLayoutPersistenceService {
    private ArchitectureSketch architecture;
    private SapphireDiagramPartListener diagramPartListener;
    private Listener componentListener;
    private Listener componentDependencyListener;
    private Map<String, DiagramNodeBounds> nodeBounds;
    private Map<ConnectionHashKey, DiagramConnectionBendPoints> connectionBendPoints;
    private boolean dirty;

    protected void init() {
        super.init();
        this.architecture = (ArchitectureSketch)((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getLocalModelElement();
        this.nodeBounds = new HashMap<String, DiagramNodeBounds>();
        this.connectionBendPoints = new HashMap<ConnectionHashKey, DiagramConnectionBendPoints>();
        this.dirty = false;
        this.load();
        this.refreshPersistedPartsCache();
        this.addDiagramPartListener();
        this.addModelListeners();
    }

    private void setGridVisible(boolean visible) {
        this.architecture.setShowGrid(visible);
    }

    private void setGuidesVisible(boolean visible) {
        this.architecture.setShowGuides(visible);
    }

    private void read(DiagramNodePart nodePart) {
        String nodeId;
        Component component = (Component)nodePart.getLocalModelElement();
        if (!component.disposed() && this.nodeBounds.containsKey(nodeId = IdUtil.computeNodeId((DiagramNodePart)nodePart)) && this.nodeBounds.get(nodeId) != null) {
            nodePart.setNodeBounds(this.nodeBounds.get(nodeId));
        }
    }

    private void write(DiagramNodePart nodePart) {
        Component component = (Component)nodePart.getLocalModelElement();
        if (!component.disposed()) {
            if (this.isNodeLayoutChanged(nodePart)) {
                this.architecture.detach(this.componentListener, "/Components/Position/*");
                this.writeComponentBounds(component, nodePart);
                this.architecture.attach(this.componentListener, "/Components/Position/*");
            }
            this.refreshDirtyState();
        }
    }

    private void read(DiagramConnectionPart connPart) {
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        if (this.connectionBendPoints.containsKey(key) && this.connectionBendPoints.get(key) != null) {
            connPart.resetBendpoints(this.connectionBendPoints.get(key));
        }
    }

    private void write(DiagramConnectionPart connPart) {
        ComponentDependency dependency = (ComponentDependency)connPart.getLocalModelElement();
        if (!dependency.disposed()) {
            if (this.isConnectionLayoutChanged(connPart)) {
                this.architecture.detach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
                this.writeDependencyBendPoints(dependency, connPart);
                this.architecture.attach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
            }
            this.refreshDirtyState();
        }
    }

    public void dispose() {
        if (this.diagramPartListener != null) {
            ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).removeListener((SapphirePartListener)this.diagramPartListener);
        }
        if (this.componentListener != null) {
            this.architecture.detach(this.componentListener, "/Components/Position/*");
        }
        if (this.componentDependencyListener != null) {
            this.architecture.detach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
        }
    }

    private void load() {
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setGridVisible(((Boolean)this.architecture.isShowGrid().getContent()).booleanValue());
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).setShowGuides(((Boolean)this.architecture.isShowGuides().getContent()).booleanValue());
        ModelElementList<Component> components = this.architecture.getComponents();
        for (Component component : components) {
            DiagramNodePart nodePart = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getDiagramNodePart((IModelElement)component);
            if (nodePart == null) continue;
            DiagramNodeBounds bounds = null;
            bounds = new DiagramNodeBounds(((Integer)component.getPosition().getX().getContent()).intValue(), ((Integer)component.getPosition().getY().getContent()).intValue(), -1, -1, false, false);
            nodePart.setNodeBounds(bounds);
            ModelElementList<ComponentDependency> dependencies = component.getDependencies();
            for (ComponentDependency dependency : dependencies) {
                ModelElementList<ConnectionBendpoint> bendpoints;
                DiagramConnectionPart connPart = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getDiagramConnectionPart((IModelElement)dependency);
                if (connPart == null || (bendpoints = dependency.getConnectionBendpoints()).size() <= 0) continue;
                int index = 0;
                for (ConnectionBendpoint bendpoint : bendpoints) {
                    connPart.addBendpoint(index++, ((Integer)bendpoint.getX().getContent()).intValue(), ((Integer)bendpoint.getY().getContent()).intValue());
                }
            }
        }
    }

    private void handleNodeLayoutChange(Component component) {
        DiagramNodePart nodePart = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getDiagramNodePart((IModelElement)component);
        DiagramNodeBounds nodeBounds = new DiagramNodeBounds(((Integer)component.getPosition().getX().getContent()).intValue(), ((Integer)component.getPosition().getY().getContent()).intValue());
        nodePart.setNodeBounds(nodeBounds);
    }

    private void handleConnectionBendpointChange(ComponentDependency componentDependency) {
        DiagramConnectionPart connPart = ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getDiagramConnectionPart((IModelElement)componentDependency);
        if (connPart != null) {
            ArrayList<Point> bendpoints = new ArrayList<Point>();
            for (ConnectionBendpoint bendpoint : componentDependency.getConnectionBendpoints()) {
                bendpoints.add(new Point(((Integer)bendpoint.getX().getContent()).intValue(), ((Integer)bendpoint.getY().getContent()).intValue()));
            }
            connPart.resetBendpoints(bendpoints, false, false);
        }
    }

    private void addNodeToPersistenceCache(DiagramNodePart nodePart) {
        String nodeId = IdUtil.computeNodeId((DiagramNodePart)nodePart);
        this.nodeBounds.put(nodeId, nodePart.getNodeBounds());
    }

    private void addConnectionToPersistenceCache(DiagramConnectionPart connPart) {
        ConnectionHashKey connKey = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        this.connectionBendPoints.put(connKey, connPart.getConnectionBendpoints());
    }

    private void addDiagramPartListener() {
        this.diagramPartListener = new SapphireDiagramPartListener(){

            public void handleNodeAddEvent(DiagramNodeEvent event) {
                ArchitectureDiagramLayoutPersistenceService.this.read((DiagramNodePart)event.getPart());
            }

            public void handleNodeMoveEvent(DiagramNodeEvent event) {
                DiagramNodePart nodePart = (DiagramNodePart)event.getPart();
                DiagramNodeBounds nodeBounds = nodePart.getNodeBounds();
                if (nodeBounds.isAutoLayout()) {
                    ArchitectureDiagramLayoutPersistenceService.this.addNodeToPersistenceCache(nodePart);
                    ArchitectureDiagramLayoutPersistenceService.this.refreshDirtyState();
                } else if (!nodeBounds.isDefaultPosition()) {
                    ArchitectureDiagramLayoutPersistenceService.this.write((DiagramNodePart)event.getPart());
                }
            }

            public void handleNodeDeleteEvent(DiagramNodeEvent event) {
                ArchitectureDiagramLayoutPersistenceService.this.refreshDirtyState();
            }

            public void handleConnectionAddEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                ArchitectureDiagramLayoutPersistenceService.this.read(connPart);
            }

            public void handleConnectionDeleteEvent(DiagramConnectionEvent event) {
                ArchitectureDiagramLayoutPersistenceService.this.refreshDirtyState();
            }

            public void handleConnectionAddBendpointEvent(DiagramConnectionEvent event) {
                ArchitectureDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionRemoveBendpointEvent(DiagramConnectionEvent event) {
                ArchitectureDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionMoveBendpointEvent(DiagramConnectionEvent event) {
                ArchitectureDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionResetBendpointsEvent(DiagramConnectionEvent event) {
                DiagramConnectionPart connPart = (DiagramConnectionPart)event.getPart();
                DiagramConnectionBendPoints bendPoints = connPart.getConnectionBendpoints();
                if (bendPoints.isAutoLayout()) {
                    ArchitectureDiagramLayoutPersistenceService.this.addConnectionToPersistenceCache(connPart);
                    ArchitectureDiagramLayoutPersistenceService.this.refreshDirtyState();
                } else if (bendPoints.isDefault()) {
                    ArchitectureDiagramLayoutPersistenceService.this.read(connPart);
                } else {
                    ArchitectureDiagramLayoutPersistenceService.this.write((DiagramConnectionPart)event.getPart());
                }
            }

            public void handleGridStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.getPart();
                ArchitectureDiagramLayoutPersistenceService.this.setGridVisible(diagramPart.isGridVisible());
            }

            public void handleGuideStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)event.getPart();
                ArchitectureDiagramLayoutPersistenceService.this.setGuidesVisible(diagramPart.isShowGuides());
            }

            public void handleDiagramSaveEvent(DiagramPageEvent event) {
                ArchitectureDiagramLayoutPersistenceService.this.doSave();
            }
        };
        ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).addListener((SapphirePartListener)this.diagramPartListener);
    }

    private void addModelListeners() {
        this.componentListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                Component component;
                if (event != null && event.element() != null && (component = (Component)event.element().nearest(Component.class)) != null) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleNodeLayoutChange(component);
                }
            }
        };
        this.componentDependencyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                ComponentDependency componentDependency;
                if (event != null && event.element() != null && (componentDependency = (ComponentDependency)event.element().nearest(ComponentDependency.class)) != null) {
                    ArchitectureDiagramLayoutPersistenceService.this.handleConnectionBendpointChange(componentDependency);
                }
            }
        };
        this.architecture.attach(this.componentListener, "/Components/Position/*");
        this.architecture.attach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
    }

    private void writeComponentBounds(Component component, DiagramNodePart node) {
        DiagramNodeBounds bounds = node.getNodeBounds();
        if (bounds.getX() != ((Integer)component.getPosition().getX().getContent()).intValue()) {
            component.getPosition().setX(bounds.getX());
        }
        if (bounds.getY() != ((Integer)component.getPosition().getY().getContent()).intValue()) {
            component.getPosition().setY(bounds.getY());
        }
    }

    private void writeDependencyBendPoints(ComponentDependency dependency, DiagramConnectionPart connPart) {
        block6: {
            int i;
            int bpInPartSize;
            int bpInModelSize;
            ModelElementList<ConnectionBendpoint> bpInModelList;
            block5: {
                bpInModelList = dependency.getConnectionBendpoints();
                bpInModelSize = bpInModelList.size();
                List bpInPartList = connPart.getConnectionBendpoints().getBendPoints();
                bpInPartSize = bpInPartList.size();
                i = 0;
                int n = Math.min(bpInModelSize, bpInPartSize);
                while (i < n) {
                    ConnectionBendpoint bpInModel = (ConnectionBendpoint)bpInModelList.get(i);
                    Point bpInPart = (Point)bpInPartList.get(i);
                    if (((Integer)bpInModel.getX().getContent()).intValue() != bpInPart.getX()) {
                        bpInModel.setX(bpInPart.getX());
                    }
                    if (((Integer)bpInModel.getY().getContent()).intValue() != bpInPart.getY()) {
                        bpInModel.setY(bpInPart.getY());
                    }
                    ++i;
                }
                if (bpInModelSize >= bpInPartSize) break block5;
                i = bpInModelSize;
                while (i < bpInPartSize) {
                    ConnectionBendpoint bpInModel = (ConnectionBendpoint)bpInModelList.insert();
                    Point bpInPart = (Point)bpInPartList.get(i);
                    bpInModel.setX(bpInPart.getX());
                    bpInModel.setY(bpInPart.getY());
                    ++i;
                }
                break block6;
            }
            if (bpInModelSize <= bpInPartSize) break block6;
            i = bpInModelSize - 1;
            while (i >= bpInPartSize) {
                bpInModelList.remove(i);
                --i;
            }
        }
    }

    private void doSave() {
        this.refreshPersistedPartsCache();
        this.architecture.detach(this.componentListener, "/Components/Position/*");
        this.architecture.detach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            Component component = (Component)nodePart.getLocalModelElement();
            if (component.disposed()) continue;
            this.writeComponentBounds(component, nodePart);
        }
        for (DiagramConnectionPart connPart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getConnections()) {
            ComponentDependency dependency = (ComponentDependency)connPart.getLocalModelElement();
            if (dependency.disposed()) continue;
            this.writeDependencyBendPoints(dependency, connPart);
        }
        this.architecture.attach(this.componentListener, "/Components/Position/*");
        this.architecture.attach(this.componentDependencyListener, "/Components/Dependencies/ConnectionBendpoints/*");
    }

    private boolean isNodeLayoutChanged(DiagramNodePart nodePart) {
        DiagramNodeBounds newBounds = nodePart.getNodeBounds();
        boolean changed = false;
        String nodeId = IdUtil.computeNodeId((DiagramNodePart)nodePart);
        if (this.nodeBounds.containsKey(nodeId)) {
            DiagramNodeBounds oldBounds = this.nodeBounds.get(nodeId);
            if (!newBounds.equals((Object)oldBounds)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isConnectionLayoutChanged(DiagramConnectionPart connPart) {
        DiagramConnectionBendPoints bendpoints = connPart.getConnectionBendpoints();
        ConnectionHashKey key = ConnectionHashKey.createKey((DiagramConnectionPart)connPart);
        boolean changed = false;
        if (this.connectionBendPoints.containsKey(key)) {
            DiagramConnectionBendPoints oldBendpoints = this.connectionBendPoints.get(key);
            if (!bendpoints.equals((Object)oldBendpoints)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private boolean isDiagramLayoutChanged() {
        boolean changed = false;
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            if (nodePart.getLocalModelElement().disposed() || !this.isNodeLayoutChanged(nodePart)) continue;
            changed = true;
            break;
        }
        for (DiagramConnectionPart connPart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getConnections()) {
            if (connPart.getLocalModelElement().disposed() || !this.isConnectionLayoutChanged(connPart)) continue;
            changed = true;
            break;
        }
        return changed;
    }

    public boolean dirty() {
        return this.dirty;
    }

    private void refreshDirtyState() {
        boolean after = this.isDiagramLayoutChanged();
        if (this.dirty != after) {
            boolean before = this.dirty;
            this.dirty = after;
            this.broadcast((ServiceEvent)new DiagramLayoutPersistenceService.DirtyStateEvent((Service)this, before, after));
        }
    }

    private void refreshPersistedPartsCache() {
        this.nodeBounds.clear();
        this.connectionBendPoints.clear();
        for (DiagramConnectionPart connPart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getConnections()) {
            this.addConnectionToPersistenceCache(connPart);
        }
        for (DiagramNodePart nodePart : ((SapphireDiagramEditorPagePart)this.context(SapphireDiagramEditorPagePart.class)).getNodes()) {
            this.addNodeToPersistenceCache(nodePart);
        }
    }
}

