/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util.internal;

import java.io.File;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.StatusException;
import org.eclipse.sapphire.modeling.util.NLS;

public final class FileUtil {
    public static void mkdirs(File f) throws StatusException {
        if (f.exists()) {
            if (f.isFile()) {
                String msg = NLS.bind(Resources.locationIsFile, f.getAbsolutePath());
                throw new StatusException(Status.createErrorStatus(msg));
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
            boolean isSuccessful = f.mkdir();
            if (!isSuccessful) {
                String msg = NLS.bind(Resources.failedToCreateDirectory, f.getAbsolutePath());
                throw new StatusException(Status.createErrorStatus(msg));
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String failedToCreateDirectory;
        public static String locationIsFile;

        static {
            Resources.initializeMessages(FileUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

