/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.util.Comparators;
import org.eclipse.sapphire.util.Filters;
import org.eclipse.sapphire.util.SortedSetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PossibleValuesService
extends Service {
    private final String invalidValueMessageTemplate;
    private final Status.Severity invalidValueSeverity;
    private final boolean caseSensitive;

    public PossibleValuesService(String invalidValueMessageTemplate, Status.Severity invalidValueSeverity, boolean caseSensitive) {
        this.invalidValueMessageTemplate = invalidValueMessageTemplate == null || invalidValueMessageTemplate.length() == 0 ? Resources.defaultInvalidValueMessage : invalidValueMessageTemplate;
        this.invalidValueSeverity = invalidValueSeverity == null ? Status.Severity.ERROR : invalidValueSeverity;
        this.caseSensitive = caseSensitive;
    }

    public PossibleValuesService() {
        this(null, null, true);
    }

    public final SortedSet<String> values() {
        Comparator<String> comparator = this.isCaseSensitive() ? null : Comparators.createIgnoreCaseComparator();
        TreeSet<String> values = new TreeSet<String>(comparator);
        this.fillPossibleValues(values);
        return SortedSetFactory.start(comparator).filter(Filters.createNotEmptyFilter()).add((Collection<String>)values).result();
    }

    protected abstract void fillPossibleValues(SortedSet<String> var1);

    public String getInvalidValueMessage(String invalidValue) {
        return NLS.bind(this.invalidValueMessageTemplate, invalidValue, this.context(ModelProperty.class).getLabel(true, CapitalizationType.NO_CAPS, false));
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return this.invalidValueSeverity;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private static final class Resources
    extends NLS {
        public static String defaultInvalidValueMessage;

        static {
            Resources.initializeMessages(PossibleValuesService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

