/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Facts;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticFactsService
extends FactsService {
    @Override
    protected void facts(SortedSet<String> facts) {
        Facts factsAnnotation;
        ModelProperty property = this.context(ModelProperty.class);
        Fact factAnnotation = property.getAnnotation(Fact.class);
        if (factAnnotation != null) {
            this.facts(facts, factAnnotation);
        }
        if ((factsAnnotation = property.getAnnotation(Facts.class)) != null) {
            Fact[] factArray = factsAnnotation.value();
            int n = factArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fact a = factArray[n2];
                this.facts(facts, a);
                ++n2;
            }
        }
    }

    private void facts(SortedSet<String> facts, Fact fact) {
        LocalizationService localization = this.context(ModelProperty.class).getLocalizationService();
        facts.add(localization.text(fact.statement(), CapitalizationType.NO_CAPS, true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && (property.hasAnnotation(Fact.class) || property.hasAnnotation(Facts.class));
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new StaticFactsService();
        }
    }
}

